/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.AbstractZipFile;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.comp.zipdriver.AbstractZipDriverEntry;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.cio.AbstractInputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@NotThreadSafe
public final class ZipInputService<E extends AbstractZipDriverEntry>
extends AbstractZipFile<E>
implements InputService<E> {
    private final AbstractZipDriver<E> driver;
    private final FsModel model;
    private ZipCryptoParameters param;

    @CreatesObligation
    public ZipInputService(FsModel model, FsInputSocketSource source, AbstractZipDriver<E> driver) throws IOException {
        super(source, driver);
        this.driver = driver;
        this.model = model;
        if (null == this.model) {
            NullPointerException ex = new NullPointerException();
            try {
                super.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param2 = this.param;
        if (null == param2) {
            this.param = param2 = this.driver.zipCryptoParameters(this);
        }
        return param2;
    }

    @Override
    public InputSocket<E> input(final String name) {
        Objects.requireNonNull(name);
        final class Input
        extends AbstractInputSocket<E> {
            Input() {
            }

            @Override
            public E target() throws IOException {
                AbstractZipDriverEntry entry2 = (AbstractZipDriverEntry)ZipInputService.this.entry(name);
                if (null == entry2) {
                    throw new NoSuchFileException(name, null, "Entry not found!");
                }
                if (entry2.isDirectory()) {
                    throw new NoSuchFileException(name, null, "Cannot read directory entries!");
                }
                return entry2;
            }

            @Override
            public InputStream stream(OutputSocket<? extends Entry> output2) throws IOException {
                Entry local = this.target();
                Entry peer = this.target(output2);
                AbstractZipDriverEntry zpeer = peer instanceof AbstractZipDriverEntry ? (AbstractZipDriverEntry)peer : null;
                AbstractZipDriver driver = ZipInputService.this.driver;
                return ZipInputService.this.getInputStream(((ZipEntry)((Object)local)).getName(), driver.check(local, ZipInputService.this), null == zpeer || 0L == zpeer.getSize() || !driver.rdc(ZipInputService.this, local, zpeer));
            }
        }
        return new Input();
    }
}

