/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.UShort;

@NotThreadSafe
final class DefaultExtraField
extends ExtraField {
    private final short headerId;
    @CheckForNull
    private byte[] data;

    DefaultExtraField(int headerId) {
        assert (UShort.check(headerId));
        this.headerId = (short)headerId;
    }

    @Override
    int getHeaderId() {
        return this.headerId & 0xFFFF;
    }

    @Override
    int getDataSize() {
        byte[] data2 = this.data;
        return null != data2 ? data2.length : 0;
    }

    @Override
    void readFrom(byte[] src, int off, int size2) {
        assert (UShort.check(size2));
        this.data = new byte[size2];
        System.arraycopy(src, off, this.data, 0, size2);
    }

    @Override
    void writeTo(byte[] dst, int off) {
        byte[] src = this.data;
        if (null != src) {
            System.arraycopy(src, 0, dst, off, src.length);
        }
    }
}

