/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class ChannelInputStream
extends InputStream {
    private final ByteBuffer single = ByteBuffer.allocate(1);
    @Nullable
    protected SeekableByteChannel channel;
    private long mark = -1L;

    public ChannelInputStream(@CheckForNull @WillCloseWhenClosed SeekableByteChannel channel2) {
        this.channel = channel2;
    }

    @Override
    public int read() throws IOException {
        this.single.rewind();
        return 1 == this.channel.read(this.single) ? this.single.get(0) & 0xFF : -1;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.channel.read(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long pos = this.channel.position();
        long size2 = this.channel.size();
        long rem = size2 - pos;
        if (n > rem) {
            n = (int)rem;
        }
        this.channel.position(pos + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        long avl = this.channel.size() - this.channel.position();
        return avl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avl;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.mark = this.channel.position();
        }
        catch (IOException ex) {
            Logger.getLogger(ChannelInputStream.class.getName()).log(Level.WARNING, ex.getLocalizedMessage(), ex);
            this.mark = -2L;
        }
    }

    @Override
    public void reset() throws IOException {
        if (0L > this.mark) {
            throw new IOException(-1L == this.mark ? "no mark set" : "mark()/reset() not supported by underlying channel");
        }
        this.channel.position(this.mark);
    }

    @Override
    public boolean markSupported() {
        try {
            this.channel.position(this.channel.position());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

