/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Formatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.DateTimeConverter;
import net.java.truevfs.comp.zip.DefaultExtraField;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.ExtraFields;
import net.java.truevfs.comp.zip.LittleEndian;
import net.java.truevfs.comp.zip.UByte;
import net.java.truevfs.comp.zip.UInt;
import net.java.truevfs.comp.zip.ULong;
import net.java.truevfs.comp.zip.UShort;
import net.java.truevfs.comp.zip.WinZipAesExtraField;

@NotThreadSafe
public class ZipEntry
implements Cloneable {
    private static final int PLATFORM = 1;
    private static final int METHOD = 2;
    private static final int CRC = 4;
    private static final int DTIME = 64;
    private static final int EATTR = 128;
    public static final byte UNKNOWN = -1;
    public static final short PLATFORM_FAT = 0;
    public static final short PLATFORM_UNIX = 3;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    public static final int BZIP2 = 12;
    static final int WINZIP_AES = 99;
    static final int GPBF_ENCRYPTED = 1;
    static final int GPBF_DATA_DESCRIPTOR = 8;
    static final int GPBF_UTF8 = 2048;
    public static final long MIN_DOS_TIME = 0x210000L;
    public static final long MAX_DOS_TIME = 4288659325L;
    private byte init;
    private String name;
    private byte platform;
    private short general;
    private short method;
    private int dtime;
    private int crc;
    private long csize = -1L;
    private long size = -1L;
    private int eattr;
    private long offset = -1L;
    @CheckForNull
    private ExtraFields fields;
    @CheckForNull
    private String comment;

    public ZipEntry(String name) {
        UShort.check(name.length());
        this.name = name;
    }

    protected ZipEntry(String name, ZipEntry template) {
        UShort.check(name.length());
        this.init = template.init;
        this.name = name;
        this.platform = template.platform;
        this.general = template.general;
        this.method = template.method;
        this.dtime = template.dtime;
        this.crc = template.crc;
        this.csize = template.csize;
        this.size = template.size;
        this.eattr = template.eattr;
        this.offset = template.offset;
        ExtraFields templateFields = template.fields;
        this.fields = templateFields == null ? null : templateFields.clone();
        this.comment = template.comment;
    }

    public ZipEntry clone() {
        ZipEntry entry2;
        try {
            entry2 = (ZipEntry)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
        ExtraFields fields = this.fields;
        entry2.fields = fields == null ? null : fields.clone();
        return entry2;
    }

    private boolean isInit(int mask) {
        return 0 != (this.init & mask);
    }

    private void setInit(int mask, boolean init2) {
        this.init = init2 ? (byte)(this.init | mask) : (byte)(this.init & ~mask);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public final int getPlatform() {
        return this.isInit(1) ? this.platform & 0xFF : -1;
    }

    public final void setPlatform(int platform) {
        boolean known;
        boolean bl = known = -1 != platform;
        if (known) {
            UByte.check(platform, this.name, "Platform out of range");
            this.platform = (byte)platform;
        } else {
            this.platform = 0;
        }
        this.setInit(1, known);
    }

    final int getRawPlatform() {
        return this.platform & 0xFF;
    }

    final void setRawPlatform(int platform) {
        assert (UByte.check(platform));
        this.platform = (byte)platform;
        this.setInit(1, true);
    }

    final int getRawVersionNeededToExtract() {
        int method = this.getRawMethod();
        return 12 == method ? 46 : (this.isZip64ExtensionsRequired() ? 45 : (8 == method || this.isDirectory() ? 20 : 10));
    }

    final int getGeneralPurposeBitFlags() {
        return this.general & 0xFFFF;
    }

    final void setGeneralPurposeBitFlags(int general) {
        assert (UShort.check(general));
        this.general = (short)general;
    }

    final boolean getGeneralPurposeBitFlag(int mask) {
        return 0 != (this.general & mask);
    }

    final void setGeneralPurposeBitFlag(int mask, boolean bit) {
        this.general = bit ? (short)(this.general | mask) : (short)(this.general & ~mask);
    }

    public final boolean isEncrypted() {
        return this.getGeneralPurposeBitFlag(1);
    }

    public final void setEncrypted(boolean encrypted) {
        this.setGeneralPurposeBitFlag(1, encrypted);
    }

    public final void clearEncryption() {
        this.setEncrypted(false);
        WinZipAesExtraField field2 = (WinZipAesExtraField)this.removeExtraField(39169);
        if (99 == this.getRawMethod()) {
            this.setRawMethod(null == field2 ? -1 : field2.getMethod());
        }
    }

    public final int getMethod() {
        return this.isInit(2) ? this.method & 0xFFFF : -1;
    }

    public final void setMethod(int method) {
        switch (method) {
            case 0: 
            case 8: 
            case 12: 
            case 99: {
                this.method = (short)method;
                this.setInit(2, true);
                break;
            }
            case -1: {
                this.method = 0;
                this.setInit(2, false);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.name + " (unsupported compression method " + method + ")");
            }
        }
    }

    final int getRawMethod() {
        return this.method & 0xFFFF;
    }

    final void setRawMethod(int method) {
        assert (UShort.check(method));
        this.method = (short)method;
        this.setInit(2, true);
    }

    public final long getTime() {
        if (!this.isInit(64)) {
            return -1L;
        }
        return this.getDateTimeConverter().toJavaTime((long)this.dtime & 0xFFFFFFFFL);
    }

    public final void setTime(long jtime) {
        boolean known = -1L != jtime;
        this.dtime = known ? (int)this.getDateTimeConverter().toDosTime(jtime) : 0;
        this.setInit(64, known);
    }

    final long getRawTime() {
        return (long)this.dtime & 0xFFFFFFFFL;
    }

    final void setRawTime(long dtime) {
        assert (UInt.check(dtime));
        this.dtime = (int)dtime;
        this.setInit(64, true);
    }

    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.JAR;
    }

    public final long getCrc() {
        return this.isInit(4) ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public final void setCrc(long crc) {
        boolean known;
        boolean bl = known = -1L != crc;
        if (known) {
            UInt.check(crc, this.name, "CRC-32 out of range");
            this.crc = (int)crc;
        } else {
            this.crc = 0;
        }
        this.setInit(4, known);
    }

    final long getRawCrc() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    final void setRawCrc(long crc) {
        assert (UInt.check(crc));
        this.crc = (int)crc;
        this.setInit(4, true);
    }

    public final long getCompressedSize() {
        return this.csize;
    }

    public final void setCompressedSize(long csize) {
        if (-1L != csize) {
            ULong.check(csize, this.name, "Compressed Size out of range");
        }
        this.csize = csize;
    }

    final long getRawCompressedSize() {
        long csize = this.csize;
        if (-1L == csize) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= csize ? 0xFFFFFFFFL : csize;
    }

    final void setRawCompressedSize(long csize) {
        assert (ULong.check(csize));
        this.csize = csize;
    }

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long size2) {
        if (-1L != size2) {
            ULong.check(size2, this.name, "Uncompressed Size out of range");
        }
        this.size = size2;
    }

    final long getRawSize() {
        long size2 = this.size;
        if (-1L == size2) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= size2 ? 0xFFFFFFFFL : size2;
    }

    final void setRawSize(long size2) {
        assert (ULong.check(size2));
        this.size = size2;
    }

    public final long getExternalAttributes() {
        return this.isInit(128) ? (long)this.eattr & 0xFFFFFFFFL : -1L;
    }

    public final void setExternalAttributes(long eattr) {
        boolean known;
        boolean bl = known = -1L != eattr;
        if (known) {
            UInt.check(eattr, this.name, "external file attributes out of range");
            this.eattr = (int)eattr;
        } else {
            this.eattr = 0;
        }
        this.setInit(128, known);
    }

    final long getRawExternalAttributes() {
        if (!this.isInit(128)) {
            return this.isDirectory() ? 16L : 0L;
        }
        return (long)this.eattr & 0xFFFFFFFFL;
    }

    final void setRawExternalAttributes(long eattr) {
        assert (UInt.check(eattr));
        this.eattr = (int)eattr;
        this.setInit(128, true);
    }

    final long getOffset() {
        return this.offset;
    }

    final long getRawOffset() {
        long offset = this.offset;
        if (-1L == offset) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= offset ? 0xFFFFFFFFL : offset;
    }

    final void setRawOffset(long offset) {
        assert (ULong.check(offset));
        this.offset = offset;
    }

    @Nullable
    final ExtraField getExtraField(int headerId) {
        ExtraFields fields = this.fields;
        return fields == null ? null : fields.get(headerId);
    }

    @Nullable
    final ExtraField addExtraField(ExtraField field2) {
        assert (null != field2);
        ExtraFields fields = this.fields;
        if (null == fields) {
            this.fields = fields = new ExtraFields();
        }
        return fields.add(field2);
    }

    @Nullable
    final ExtraField removeExtraField(int headerId) {
        ExtraFields fields = this.fields;
        return null != fields ? fields.remove(headerId) : null;
    }

    public final byte[] getExtra() {
        return this.getExtraFields(false);
    }

    public final void setExtra(@CheckForNull byte[] buf) throws IllegalArgumentException {
        if (null != buf) {
            UShort.check(buf.length, "Extra Fields too large", null);
            this.setExtraFields(buf, false);
        } else {
            this.fields = null;
        }
    }

    final byte[] getRawExtraFields() {
        return this.getExtraFields(true);
    }

    final void setRawExtraFields(byte[] buf) throws IllegalArgumentException {
        this.setExtraFields(buf, true);
    }

    private byte[] getExtraFields(boolean zip64) {
        ExtraFields fields = this.fields;
        if (zip64) {
            ExtraField field2 = this.composeZip64ExtraField();
            if (null != field2) {
                fields = null != fields ? fields.clone() : new ExtraFields();
                fields.add(field2);
            }
        } else assert (null == fields || null == fields.get(1));
        return null == fields ? Constants.EMPTY : fields.getDataBlock();
    }

    private void setExtraFields(byte[] buf, boolean zip64) throws IllegalArgumentException {
        assert (UShort.check(buf.length));
        if (0 < buf.length) {
            ExtraFields fields = new ExtraFields();
            fields.readFrom(buf, 0, buf.length);
            try {
                if (zip64) {
                    this.parseZip64ExtraField(fields);
                }
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(ex);
            }
            fields.remove(1);
            this.fields = 0 < fields.size() ? fields : null;
        } else {
            this.fields = null;
        }
    }

    @CheckForNull
    private ExtraField composeZip64ExtraField() {
        DefaultExtraField field2;
        byte[] data2 = new byte[24];
        int off = 0;
        long size2 = this.getSize();
        if (Constants.FORCE_ZIP64_EXT && -1L != size2 || 0xFFFFFFFFL <= size2) {
            LittleEndian.writeLong(size2, data2, off);
            off += 8;
        }
        long csize = this.getCompressedSize();
        if (Constants.FORCE_ZIP64_EXT && -1L != csize || 0xFFFFFFFFL <= csize) {
            LittleEndian.writeLong(csize, data2, off);
            off += 8;
        }
        long offset = this.getOffset();
        if (Constants.FORCE_ZIP64_EXT && -1L != offset || 0xFFFFFFFFL <= offset) {
            LittleEndian.writeLong(offset, data2, off);
            off += 8;
        }
        if (off > 0) {
            field2 = new DefaultExtraField(1);
            ((ExtraField)field2).readFrom(data2, 0, off);
        } else {
            field2 = null;
        }
        return field2;
    }

    private void parseZip64ExtraField(ExtraFields fields) throws IndexOutOfBoundsException {
        long offset;
        long csize;
        ExtraField ef = fields.get(1);
        if (null == ef) {
            return;
        }
        byte[] data2 = ef.getDataBlock();
        int off = 0;
        long size2 = this.getRawSize();
        if (0xFFFFFFFFL <= size2) {
            assert (0xFFFFFFFFL == size2);
            this.setRawSize(LittleEndian.readLong(data2, off));
            off += 8;
        }
        if (0xFFFFFFFFL <= (csize = this.getRawCompressedSize())) {
            assert (0xFFFFFFFFL == csize);
            this.setRawCompressedSize(LittleEndian.readLong(data2, off));
            off += 8;
        }
        if (0xFFFFFFFFL <= (offset = this.getRawOffset())) {
            assert (0xFFFFFFFFL == offset);
            this.setRawOffset(LittleEndian.readLong(data2, off));
        }
    }

    @CheckForNull
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@CheckForNull String comment2) {
        if (null != comment2) {
            UShort.check(comment2.length(), this.name, "Comment too long");
        }
        this.comment = comment2;
    }

    final String getRawComment() {
        String comment2 = this.comment;
        return null != comment2 ? comment2 : "";
    }

    final void setRawComment(String comment2) {
        assert (UShort.check(comment2.length()));
        this.comment = comment2;
    }

    final boolean isDataDescriptorRequired() {
        return -1L == (this.getCrc() | this.getCompressedSize() | this.getSize());
    }

    final boolean isZip64ExtensionsRequired() {
        if (Constants.FORCE_ZIP64_EXT) {
            return true;
        }
        return 0xFFFFFFFFL <= this.getCompressedSize() || 0xFFFFFFFFL <= this.getSize() || 0xFFFFFFFFL <= this.getOffset();
    }

    public String toString() {
        String comment2;
        StringBuilder s = new StringBuilder(256);
        Formatter f2 = new Formatter(s).format("%s[name=%s", this.getClass().getName(), this.getName());
        long value2 = this.getGeneralPurposeBitFlags();
        if (-1L != value2) {
            f2.format(", gpbf=0x%04X", value2);
        }
        if (-1L != (value2 = (long)this.getMethod())) {
            f2.format(", method=%d", value2);
        }
        if (-1L != (value2 = this.getTime())) {
            f2.format(", time=%tc", value2);
        }
        if (-1L != (value2 = this.getCrc())) {
            f2.format(", crc=0x%08X", value2);
        }
        if (-1L != (value2 = this.getCompressedSize())) {
            f2.format(", compressedSize=%d", value2);
        }
        if (-1L != (value2 = this.getSize())) {
            f2.format(", size=%d", value2);
        }
        if (-1L != (value2 = this.getExternalAttributes())) {
            f2.format(", ea=0x%08X", value2);
        }
        if (null != (comment2 = this.getComment())) {
            f2.format(", comment=\"%s\"", comment2);
        }
        return s.append("]").toString();
    }
}

