/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.LittleEndian;
import net.java.truevfs.comp.zip.UShort;

@NotThreadSafe
final class ExtraFields
implements Cloneable {
    private Map<Integer, ExtraField> extra = new TreeMap<Integer, ExtraField>();

    ExtraFields() {
    }

    public ExtraFields clone() {
        try {
            ExtraFields clone2 = (ExtraFields)super.clone();
            clone2.extra = new TreeMap<Integer, ExtraField>(this.extra);
            return clone2;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    int size() {
        return this.extra.size();
    }

    @CheckForNull
    ExtraField get(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.get(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    ExtraField add(ExtraField ef) {
        int headerId = ef.getHeaderId();
        assert (UShort.check(headerId));
        return this.extra.put(headerId, ef);
    }

    @Nullable
    ExtraField remove(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.remove(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    int getDataSize() {
        Map<Integer, ExtraField> extra = this.extra;
        if (extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        for (ExtraField ef : extra.values()) {
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getDataBlock() {
        int size2 = this.getDataSize();
        assert (UShort.check(size2));
        if (0 == size2) {
            return Constants.EMPTY;
        }
        byte[] data2 = new byte[size2];
        this.writeTo(data2, 0);
        return data2;
    }

    void readFrom(byte[] buf, int off, int len) throws IndexOutOfBoundsException, IllegalArgumentException {
        assert (UShort.check(len));
        TreeMap<Integer, ExtraField> map2 = new TreeMap<Integer, ExtraField>();
        if (null != buf && 0 < len) {
            int end = off + len;
            while (off < end) {
                int headerId = LittleEndian.readUShort(buf, off);
                int dataSize = LittleEndian.readUShort(buf, off += 2);
                off += 2;
                ExtraField ef = ExtraField.create(headerId);
                try {
                    ef.readFrom(buf, off, dataSize);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException(ex);
                }
                off += dataSize;
                map2.put(headerId, ef);
            }
            assert (off == end);
        }
        this.extra = map2;
    }

    void writeTo(byte[] buf, int off) throws IndexOutOfBoundsException {
        for (ExtraField ef : this.extra.values()) {
            LittleEndian.writeShort(ef.getHeaderId(), buf, off);
            LittleEndian.writeShort(ef.getDataSize(), buf, off += 2);
            ef.writeTo(buf, off += 2);
            off += ef.getDataSize();
        }
    }
}

