/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public interface Link<T> {
    @Nullable
    public T get();

    public static enum Type {
        STRONG{

            @Override
            <T> Link<T> newLink(@CheckForNull T target2, ReferenceQueue<? super T> queue) {
                return new Strong<T>(target2);
            }
        }
        ,
        SOFT{

            @Override
            <T> Link<T> newLink(@CheckForNull T target2, ReferenceQueue<? super T> queue) {
                return new Soft<T>(target2, queue);
            }
        }
        ,
        WEAK{

            @Override
            <T> Link<T> newLink(@CheckForNull T target2, ReferenceQueue<? super T> queue) {
                return new Weak<T>(target2, queue);
            }
        }
        ,
        PHANTOM{

            @Override
            public <T> Link<T> newLink(@CheckForNull T target2, ReferenceQueue<? super T> queue) {
                return new Phantom<T>(target2, queue);
            }
        };


        abstract <T> Link<T> newLink(@CheckForNull T var1, @CheckForNull ReferenceQueue<? super T> var2);

        public <T> Link<T> newLink(@CheckForNull T target2) {
            return this.newLink(target2, null);
        }

        private static final class Phantom<T>
        extends PhantomReference<T>
        implements Link<T> {
            Phantom(T target2, ReferenceQueue<? super T> queue) {
                super(target2, queue);
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.get());
            }
        }

        private static final class Weak<T>
        extends WeakReference<T>
        implements Link<T> {
            Weak(T target2, ReferenceQueue<? super T> queue) {
                super(target2, queue);
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.get());
            }
        }

        private static final class Soft<T>
        extends SoftReference<T>
        implements Link<T> {
            Soft(T target2, ReferenceQueue<? super T> queue) {
                super(target2, queue);
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.get());
            }
        }

        private static final class Strong<T>
        implements Link<T> {
            @CheckForNull
            private final T target;

            Strong(@CheckForNull T target2) {
                this.target = target2;
            }

            @Override
            public T get() {
                return this.target;
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.get());
            }
        }
    }
}

