/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.java.truecommons.jmx.ObjectNameBuilder;
import net.java.truecommons.jmx.sl.MBeanServerLocator;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truevfs.comp.inst.Mediator;
import net.java.truevfs.comp.jmx.JmxComponent;
import org.slf4j.Logger;

@ThreadSafe
public abstract class JmxMediator<This extends JmxMediator<This>>
extends Mediator<This> {
    private static final Logger logger = new LocalizedLogger(JmxMediator.class);

    public Package getDomain() {
        return this.getClass().getPackage();
    }

    public ObjectNameBuilder nameBuilder(Class<?> type) {
        return new ObjectNameBuilder(this.getDomain()).put("type", type.getSimpleName());
    }

    public MBeanServer getMBeanServer() {
        return MBeanServerLocator.SINGLETON.get();
    }

    public <C extends JmxComponent> C activate(C component) {
        component.activate();
        return component;
    }

    public boolean register(@CheckForNull ObjectName name, Object mbean) {
        try {
            this.getMBeanServer().registerMBean(mbean, name);
            return true;
        }
        catch (InstanceAlreadyExistsException ex) {
            logger.warn("instanceAlreadyExists.warn", (Object)name);
            logger.trace("instanceAlreadyExists.trace", ex);
            return false;
        }
        catch (JMException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public boolean deregister(ObjectName name) {
        try {
            this.getMBeanServer().unregisterMBean(name);
            return true;
        }
        catch (InstanceNotFoundException ex) {
            logger.warn("instanceNotFound.warn", (Object)name);
            logger.trace("instanceNotFound.trace", ex);
            return false;
        }
        catch (JMException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

