/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileComparator;
import net.java.truevfs.access.swing.TFileTreeCellRenderer;
import net.java.truevfs.access.swing.TFileTreeModel;
import org.slf4j.LoggerFactory;

public final class TFileTree
extends JTree {
    private static final long serialVersionUID = 1064787562479927601L;
    private static final String PROPERTY_DISPLAYING_EXTENSIONS = "displayingExtensions";
    private static final String PROPERTY_EDITING_EXTENSIONS = "editingExtensions";
    private static final String PROPERTY_DEFAULT_EXTENSION = "defaultExtension";
    private final Controller controller = new Controller();
    private boolean displayingExtensions = true;
    private boolean editingExtensions = true;
    @CheckForNull
    private String defaultExtension;
    @CheckForNull
    private transient TFile editedNode;

    public TFileTree() {
        this(new TFileTreeModel(null, null, new TFileComparator()));
    }

    public TFileTree(TFile root) {
        this(new TFileTreeModel(root, null, new TFileComparator()));
    }

    public TFileTree(TFileTreeModel model) {
        super(model);
        super.addTreeExpansionListener(this.controller);
        super.setCellRenderer(new TFileTreeCellRenderer(this));
    }

    @Override
    public TFileTreeModel getModel() {
        return (TFileTreeModel)super.getModel();
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setModel(TreeModel model) {
        super.setModel((TFileTreeModel)Objects.requireNonNull(model));
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor ce = this.getCellEditor();
            if (ce != null) {
                ce.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingExtensions() {
        return this.displayingExtensions;
    }

    public void setDisplayingExtensions(boolean displayingExtensions) {
        boolean oldDisplayingExtensions = this.displayingExtensions;
        this.displayingExtensions = displayingExtensions;
        this.firePropertyChange(PROPERTY_DISPLAYING_EXTENSIONS, oldDisplayingExtensions, displayingExtensions);
    }

    public boolean isEditingExtensions() {
        return this.editingExtensions;
    }

    public void setEditingExtensions(boolean editingExtensions) {
        boolean oldEditingExtensions = this.editingExtensions;
        this.editingExtensions = editingExtensions;
        this.firePropertyChange(PROPERTY_EDITING_EXTENSIONS, oldEditingExtensions, editingExtensions);
    }

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(@CheckForNull String defaultExtension) {
        String oldDefaultExtension = this.defaultExtension;
        if (null != defaultExtension) {
            if ((defaultExtension = defaultExtension.trim()).length() <= 0) {
                defaultExtension = null;
            } else if (defaultExtension.charAt(0) != '.') {
                defaultExtension = "." + defaultExtension;
            }
        }
        this.defaultExtension = defaultExtension;
        this.firePropertyChange(PROPERTY_DEFAULT_EXTENSION, oldDefaultExtension, defaultExtension);
    }

    @Nullable
    TFile getEditedNode() {
        return this.editedNode;
    }

    @Override
    public boolean isEditing() {
        return null != this.editedNode;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        this.editedNode = (TFile)path.getLastPathComponent();
        super.startEditingAtPath(path);
    }

    @Override
    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    @Override
    public boolean stopEditing() {
        boolean stop = super.stopEditing();
        if (stop) {
            this.editedNode = null;
        }
        return stop;
    }

    protected void onEditingStopped(ChangeEvent evt) {
        TreeCellEditor tce = (TreeCellEditor)evt.getSource();
        String member = tce.getCellEditorValue().toString().trim();
        TFile oldNode = (TFile)this.getLeadSelectionPath().getLastPathComponent();
        TFile parent = oldNode.getParentFile();
        assert (parent != null);
        if (!oldNode.isDirectory()) {
            String extension2;
            if (this.isDisplayingExtensions() && this.isEditingExtensions()) {
                String defaultExtension;
                extension2 = this.getExtension(member);
                if (null == extension2 && (defaultExtension = this.getDefaultExtension()) != null) {
                    member = member + defaultExtension;
                }
            } else {
                extension2 = this.getExtension(oldNode.getName());
                if (null != extension2) {
                    member = member + extension2;
                }
            }
        }
        TFile node2 = new TFile((File)parent, member);
        try {
            this.mv(oldNode, node2);
        }
        catch (IOException ex) {
            Toolkit.getDefaultToolkit().beep();
            LoggerFactory.getLogger(TFileTree.class).warn("Stack trace:", ex);
        }
    }

    @Nullable
    private String getExtension(String base) {
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(i) : null;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TFile node2 = (TFile)value;
        TFile editedNode = this.getEditedNode();
        if (node2 != editedNode && !node2.exists()) {
            return "?";
        }
        String base = node2.getName();
        if (base.length() <= 0) {
            return node2.getPath();
        }
        if (node2.isDirectory() || this.isDisplayingExtensions() && (!node2.equals(editedNode) || this.isEditingExtensions())) {
            return base;
        }
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(0, i) : base;
    }

    public void refresh() {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(ftm.getRoot());
        if (null != path) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TFile node2) {
        Objects.requireNonNull(node2);
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (path != null) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TreePath[] paths) {
        if (paths == null || paths.length <= 0) {
            return;
        }
        TFileTreeModel ftm = this.getModel();
        TreePath lead = this.getLeadSelectionPath();
        TreePath anchor = this.getAnchorSelectionPath();
        TreePath[] selections = this.getSelectionPaths();
        for (TreePath path : paths) {
            Enumeration<TreePath> expansions = this.getExpandedDescendants(path);
            ftm.refresh((TFile)path.getLastPathComponent());
            this.setExpandedDescendants(expansions);
        }
        this.setSelectionPaths(selections);
        this.setAnchorSelectionPath(anchor);
        this.setLeadSelectionPath(lead);
        this.scrollPathToVisible(lead);
    }

    private void setExpandedDescendants(Enumeration<TreePath> expansions) {
        if (expansions == null) {
            return;
        }
        while (expansions.hasMoreElements()) {
            this.setExpandedState(expansions.nextElement(), true);
        }
    }

    public boolean createNewFile(TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            return false;
        }
        if (!ftm.createNewFile(node2)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public void mkdir(TFile node2, boolean recursive) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            return;
        }
        ftm.mkdir(node2, recursive);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp(@WillClose InputStream in, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp(in, node2);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp(TFile oldNode, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp(oldNode, node2);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_r(TFile oldNode, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_r(oldNode, node2);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_p(TFile oldNode, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_p(oldNode, node2);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_rp(TFile oldNode, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_rp(oldNode, node2);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void mv(TFile oldNode, TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        TreePath oldPath = ftm.newTreePath(oldNode);
        Enumeration<TreePath> expansions = oldPath == null ? null : this.getExpandedDescendants(oldPath);
        ftm.mv(oldNode, node2);
        if (null != expansions) {
            while (expansions.hasMoreElements()) {
                this.setExpandedState(this.substPath(expansions.nextElement(), oldPath, path), true);
            }
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    private TreePath substPath(TreePath tp, TreePath oldPath, TreePath path) {
        TFile file = (TFile)tp.getLastPathComponent();
        if (file.equals(oldPath.getLastPathComponent())) {
            return path;
        }
        TreePath parent = this.substPath(tp.getParentPath(), oldPath, path);
        return parent.pathByAddingChild(new TFile((File)((TFile)parent.getLastPathComponent()), file.getName()));
    }

    public void rm(TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        ftm.rm(node2);
        this.setSelectionRow(row);
    }

    public void rm_r(TFile node2) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        ftm.rm_r(node2);
        this.setSelectionRow(row);
    }

    public void setSelectionNode(TFile node2) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (null != path) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectionNodes(TFile[] nodes) {
        TFileTreeModel ftm = this.getModel();
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        int l = nodes.length;
        for (int i = 0; i < l; ++i) {
            TreePath lastPath = ftm.newTreePath(nodes[i]);
            if (lastPath == null) continue;
            list.add(lastPath);
        }
        int size2 = list.size();
        if (size2 > 0) {
            TreePath[] paths = new TreePath[size2];
            list.toArray(paths);
            this.setSelectionPaths(paths);
        }
    }

    public void scrollNodeToVisible(TFile node2) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node2);
        if (path != null) {
            this.scrollPathToVisible(path);
        }
    }

    private final class Controller
    implements TreeExpansionListener,
    CellEditorListener,
    Serializable {
        private static final long serialVersionUID = 6402557248752695675L;

        private Controller() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
            TFileTree.this.getModel().forget((TFile)evt.getPath().getLastPathComponent());
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
        }

        @Override
        public void editingCanceled(ChangeEvent evt) {
        }

        @Override
        public void editingStopped(ChangeEvent evt) {
            TFileTree.this.onEditingStopped(evt);
        }
    }
}

