/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.inject.Provider;
import net.java.truecommons.services.Loader;
import net.java.truecommons.shed.ExtensionSet;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.kernel.spec.FsAbstractCompositeDriver;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;

@Immutable
public final class TArchiveDetector
extends FsAbstractCompositeDriver {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final ExtensionSet extensions;
    private final Map<FsScheme, FsDriver> drivers;

    private static ExtensionSet extensions(Provider<Map<FsScheme, FsDriver>> provider) {
        if (provider instanceof TArchiveDetector) {
            return new ExtensionSet(((TArchiveDetector)provider).extensions);
        }
        Map map2 = (Map)provider.get();
        ExtensionSet set = new ExtensionSet();
        for (Map.Entry entry2 : map2.entrySet()) {
            if (!((FsDriver)entry2.getValue()).isArchiveDriver()) continue;
            set.add(((FsScheme)entry2.getKey()).toString());
        }
        return set;
    }

    private static Map<FsScheme, FsDriver> map(Object[][] config) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity(config.length) * 2);
        for (Object[] param2 : config) {
            Collection<FsScheme> schemes = TArchiveDetector.schemes(param2[0]);
            if (schemes.isEmpty()) {
                throw new IllegalArgumentException("No file system schemes!");
            }
            FsDriver driver = Loader.promote(param2[1], FsDriver.class);
            for (FsScheme scheme : schemes) {
                drivers.put(scheme, driver);
            }
        }
        return Collections.unmodifiableMap(drivers);
    }

    private static Collection<FsScheme> schemes(Object o) {
        TreeSet<FsScheme> set = new TreeSet<FsScheme>();
        try {
            if (o instanceof Collection) {
                for (Object p : (Collection)o) {
                    if (p instanceof FsScheme) {
                        set.add((FsScheme)p);
                        continue;
                    }
                    for (String q : new ExtensionSet(p.toString())) {
                        set.add(new FsScheme(q));
                    }
                }
            } else if (o instanceof FsScheme) {
                set.add((FsScheme)o);
            } else {
                for (String p : new ExtensionSet(o.toString())) {
                    set.add(new FsScheme(p));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return set;
    }

    public TArchiveDetector(@CheckForNull String extensions) {
        this((Provider<Map<FsScheme, FsDriver>>)FsDriverMapLocator.SINGLETON, extensions);
    }

    public TArchiveDetector(Provider<Map<FsScheme, FsDriver>> provider, @CheckForNull String extensions) {
        ExtensionSet accepted;
        ExtensionSet available = TArchiveDetector.extensions(provider);
        if (null == extensions) {
            accepted = available;
        } else {
            accepted = new ExtensionSet(extensions);
            if (accepted.retainAll(available)) {
                accepted = new ExtensionSet(extensions);
                accepted.removeAll(available);
                assert (!accepted.isEmpty());
                throw new IllegalArgumentException("\"" + accepted + "\" (no archive driver installed for these extensions)");
            }
        }
        this.extensions = accepted;
        this.drivers = (Map)provider.get();
    }

    public TArchiveDetector(String extensions, @CheckForNull FsDriver driver) {
        this(NULL, extensions, driver);
    }

    public TArchiveDetector(Provider<Map<FsScheme, FsDriver>> provider, String extensions, @CheckForNull FsDriver driver) {
        this(provider, new Object[][]{{extensions, driver}});
    }

    public TArchiveDetector(Provider<Map<FsScheme, FsDriver>> provider, Object[][] config) {
        this(provider, TArchiveDetector.map(config));
    }

    public TArchiveDetector(Provider<Map<FsScheme, FsDriver>> provider, Map<FsScheme, FsDriver> config) {
        ExtensionSet extensions = TArchiveDetector.extensions(provider);
        Map available = (Map)provider.get();
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity(available.size() + config.size()));
        drivers.putAll(available);
        for (Map.Entry<FsScheme, FsDriver> entry2 : config.entrySet()) {
            FsScheme scheme = entry2.getKey();
            FsDriver driver = entry2.getValue();
            if (null != driver) {
                extensions.add(scheme.toString());
                drivers.put(scheme, driver);
                continue;
            }
            extensions.remove(scheme.toString());
        }
        this.extensions = extensions;
        this.drivers = Collections.unmodifiableMap(drivers);
    }

    public String getExtensions() {
        return this.extensions.toString();
    }

    public Map<FsScheme, FsDriver> getDrivers() {
        return this.drivers;
    }

    @Override
    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme scheme(String path) {
        path = path.replace('/', File.separatorChar);
        int i = path.lastIndexOf(File.separatorChar) + 1;
        path = path.substring(i);
        int l = path.length();
        i = 0;
        while (0 < (i = path.indexOf(46, i) + 1) && i < l) {
            String scheme = path.substring(i);
            if (!this.extensions.contains(scheme)) continue;
            try {
                return new FsScheme(scheme);
            }
            catch (URISyntaxException noSchemeNoArchiveBadLuck) {
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TArchiveDetector)) {
            return false;
        }
        TArchiveDetector that = (TArchiveDetector)other;
        return this.extensions.equals(that.extensions) && this.drivers.equals(that.drivers);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.extensions.hashCode();
        hash = 59 * hash + this.drivers.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("%s[extensions=%s, drivers=%s]", this.getClass().getName(), this.extensions, this.drivers);
    }
}

