/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ReadOnlyChannel;

@NotThreadSafe
public final class IntervalReadOnlyChannel
extends ReadOnlyChannel {
    private final long start;
    private final long size;
    private final boolean exclusive;
    private long pos;

    public IntervalReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel2, long size2) throws IOException {
        this(channel2, channel2.position(), size2, true);
    }

    public IntervalReadOnlyChannel(@WillNotClose SeekableByteChannel channel2, long start, long size2) throws IOException {
        this(channel2, start, size2, false);
    }

    private IntervalReadOnlyChannel(SeekableByteChannel channel2, long start, long size2, boolean exclusive) throws IOException {
        super(channel2);
        if (start < 0L || size2 < 0L || channel2.size() < start + size2) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.size = size2;
        this.exclusive = exclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read;
        int limit;
        long size2;
        int remaining = dst.remaining();
        if (0 >= remaining) {
            return 0;
        }
        long pos = this.position();
        if (pos >= (size2 = this.size)) {
            return -1;
        }
        long available = size2 - pos;
        if ((long)remaining > available) {
            remaining = (int)available;
            limit = dst.limit();
            dst.limit(dst.position() + remaining);
        } else {
            limit = -1;
        }
        try {
            if (!this.exclusive) {
                this.channel.position(this.start + pos);
            }
            read = this.channel.read(dst);
        }
        finally {
            if (0 <= limit) {
                dst.limit(limit);
            }
        }
        this.pos = pos + (long)read;
        if (0 == remaining) {
            assert (0 >= read);
            return -1;
        }
        assert (0 < read);
        return read;
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.pos;
    }

    @Override
    public SeekableByteChannel position(long pos) throws IOException {
        if (0L > pos) {
            throw new IllegalArgumentException();
        }
        this.channel.position(this.start + pos);
        this.pos = pos;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.size;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        if (this.exclusive) {
            this.channel.close();
        }
    }
}

