/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing.io;

import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileSystemView;
import net.java.truecommons.key.swing.util.AbstractComboBoxBrowser;

public class FileComboBoxBrowser
extends AbstractComboBoxBrowser<String> {
    private static final long serialVersionUID = -6878885832542209810L;
    @CheckForNull
    private transient FileSystemView fsv;
    @CheckForNull
    private transient File dir;

    public FileComboBoxBrowser() {
        this((JComboBox<String>)null);
    }

    public FileComboBoxBrowser(@CheckForNull JComboBox<String> comboBox) {
        super(comboBox);
        if (null != comboBox) {
            this.update0(Objects.toString(comboBox.getSelectedItem(), ""));
        }
    }

    public FileSystemView getFileSystemView() {
        FileSystemView fsv = this.fsv;
        return null != fsv ? fsv : (this.fsv = FileSystemView.getFileSystemView());
    }

    public void setFileSystemView(@CheckForNull FileSystemView fsv) {
        this.fsv = fsv;
    }

    public File getDirectory() {
        File dir = this.dir;
        return null != dir ? dir : (this.dir = this.getFileSystemView().getDefaultDirectory());
    }

    public void setDirectory(@CheckForNull File dir) {
        this.dir = dir;
    }

    @Override
    protected boolean update(String initials) {
        return this.update0(initials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update0(String initials) {
        String prefix;
        String base;
        File dir = this.getDirectory();
        if ("".equals(initials)) {
            base = "";
            prefix = "";
        } else {
            File node2 = this.getFileSystemView().createFileObject(initials);
            if (node2.isAbsolute()) {
                boolean dirPath;
                boolean bl = dirPath = node2.getPath().length() < initials.length();
                if (dirPath && node2.isDirectory()) {
                    dir = node2;
                    prefix = "";
                } else {
                    dir = node2.getParentFile();
                    if (dir == null) {
                        dir = node2;
                        prefix = "";
                    } else {
                        prefix = node2.getName();
                    }
                }
                base = dir.getPath().endsWith(File.separator) ? initials.substring(0, dir.getPath().length()) : initials.substring(0, dir.getPath().length() + 1);
            } else {
                boolean dirPath;
                File directory = dir;
                node2 = this.getFileSystemView().createFileObject(directory, initials);
                boolean bl = dirPath = node2.getPath().length() < (directory.getPath() + File.separator + initials).length();
                if (dirPath && node2.isDirectory()) {
                    dir = node2;
                    prefix = "";
                } else {
                    dir = node2.getParentFile();
                    assert (null != dir);
                    prefix = node2.getName();
                }
                base = initials.substring(0, dir.getPath().length() - directory.getPath().length());
            }
        }
        class Filter
        implements FilenameFilter {
            final int pl;

            Filter() {
                this.pl = prefix.length();
            }

            @Override
            public boolean accept(File d, String child) {
                return this.pl <= child.length() ? prefix.equalsIgnoreCase(child.substring(0, this.pl)) : false;
            }
        }
        String[] children = dir.list(new Filter());
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getComboBox().getModel();
        try {
            int l;
            model.removeAllElements();
            int n = l = null == children ? 0 : children.length;
            if (0 < l) {
                Arrays.sort(children, Collator.getInstance());
                for (int i = 0; i < l; ++i) {
                    model.addElement(base + children[i]);
                }
                boolean bl = true;
                return bl;
            }
            model.addElement(initials);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!initials.equals(model.getSelectedItem())) {
                model.setSelectedItem(initials);
            }
        }
    }
}

