/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.cio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.MemoryBuffer;

@ThreadSafe
public final class MemoryBufferPool
extends IoBufferPool {
    private static final String BUFFER_NAME = "buffer-";
    private final int initialCapacity;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger active = new AtomicInteger();

    public MemoryBufferPool(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @Override
    public IoBuffer allocate() {
        Buffer buffer = new Buffer(this.total.getAndIncrement());
        this.active.getAndIncrement();
        return buffer;
    }

    public int size() {
        return this.active.get();
    }

    @NotThreadSafe
    private final class Buffer
    extends MemoryBuffer {
        private boolean released;

        Buffer(int i) {
            super(MemoryBufferPool.BUFFER_NAME + i, MemoryBufferPool.this.initialCapacity);
        }

        @Override
        public void release() throws IOException {
            if (this.released) {
                return;
            }
            MemoryBufferPool.this.active.getAndDecrement();
            super.release();
            this.released = true;
        }
    }
}

