/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioConstants;
import org.apache.commons.compress.archivers.cpio.CpioUtil;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.ArchiveUtils;

public class CpioArchiveOutputStream
extends ArchiveOutputStream
implements CpioConstants {
    private CpioArchiveEntry entry;
    private boolean closed = false;
    private boolean finished;
    private final short entryFormat;
    private final HashMap<String, CpioArchiveEntry> names = new HashMap();
    private long crc = 0L;
    private long written;
    private final OutputStream out;
    private final int blockSize;
    private long nextArtificalDeviceAndInode = 1L;
    private final ZipEncoding encoding;

    public CpioArchiveOutputStream(OutputStream out, short format2) {
        this(out, format2, 512, "US-ASCII");
    }

    public CpioArchiveOutputStream(OutputStream out, short format2, int blockSize) {
        this(out, format2, blockSize, "US-ASCII");
    }

    public CpioArchiveOutputStream(OutputStream out, short format2, int blockSize, String encoding) {
        this.out = out;
        switch (format2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + format2);
            }
        }
        this.entryFormat = format2;
        this.blockSize = blockSize;
        this.encoding = ZipEncodingHelper.getZipEncoding(encoding);
    }

    public CpioArchiveOutputStream(OutputStream out) {
        this(out, 1);
    }

    public CpioArchiveOutputStream(OutputStream out, String encoding) {
        this(out, 1, 512, encoding);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void putArchiveEntry(ArchiveEntry entry2) throws IOException {
        short format2;
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        CpioArchiveEntry e = (CpioArchiveEntry)entry2;
        this.ensureOpen();
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        if (e.getTime() == -1L) {
            e.setTime(System.currentTimeMillis() / 1000L);
        }
        if ((format2 = e.getFormat()) != this.entryFormat) {
            throw new IOException("Header format: " + format2 + " does not match existing format: " + this.entryFormat);
        }
        if (this.names.put(e.getName(), e) != null) {
            throw new IOException("duplicate entry: " + e.getName());
        }
        this.writeHeader(e);
        this.entry = e;
        this.written = 0L;
    }

    private void writeHeader(CpioArchiveEntry e) throws IOException {
        switch (e.getFormat()) {
            case 1: {
                this.out.write(ArchiveUtils.toAsciiBytes("070701"));
                this.count(6);
                this.writeNewEntry(e);
                break;
            }
            case 2: {
                this.out.write(ArchiveUtils.toAsciiBytes("070702"));
                this.count(6);
                this.writeNewEntry(e);
                break;
            }
            case 4: {
                this.out.write(ArchiveUtils.toAsciiBytes("070707"));
                this.count(6);
                this.writeOldAsciiEntry(e);
                break;
            }
            case 8: {
                boolean swapHalfWord = true;
                this.writeBinaryLong(29127L, 2, swapHalfWord);
                this.writeOldBinaryEntry(e, swapHalfWord);
            }
        }
    }

    private void writeNewEntry(CpioArchiveEntry entry2) throws IOException {
        long inode = entry2.getInode();
        long devMin = entry2.getDeviceMin();
        if ("TRAILER!!!".equals(entry2.getName())) {
            devMin = 0L;
            inode = 0L;
        } else if (inode == 0L && devMin == 0L) {
            inode = this.nextArtificalDeviceAndInode & 0xFFFFFFFFFFFFFFFFL;
            devMin = this.nextArtificalDeviceAndInode++ >> 32 & 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, inode + 0x100000000L * devMin) + 1L;
        }
        this.writeAsciiLong(inode, 8, 16);
        this.writeAsciiLong(entry2.getMode(), 8, 16);
        this.writeAsciiLong(entry2.getUID(), 8, 16);
        this.writeAsciiLong(entry2.getGID(), 8, 16);
        this.writeAsciiLong(entry2.getNumberOfLinks(), 8, 16);
        this.writeAsciiLong(entry2.getTime(), 8, 16);
        this.writeAsciiLong(entry2.getSize(), 8, 16);
        this.writeAsciiLong(entry2.getDeviceMaj(), 8, 16);
        this.writeAsciiLong(devMin, 8, 16);
        this.writeAsciiLong(entry2.getRemoteDeviceMaj(), 8, 16);
        this.writeAsciiLong(entry2.getRemoteDeviceMin(), 8, 16);
        this.writeAsciiLong(entry2.getName().length() + 1, 8, 16);
        this.writeAsciiLong(entry2.getChksum(), 8, 16);
        this.writeCString(entry2.getName());
        this.pad(entry2.getHeaderPadCount());
    }

    private void writeOldAsciiEntry(CpioArchiveEntry entry2) throws IOException {
        long inode = entry2.getInode();
        long device = entry2.getDevice();
        if ("TRAILER!!!".equals(entry2.getName())) {
            device = 0L;
            inode = 0L;
        } else if (inode == 0L && device == 0L) {
            inode = this.nextArtificalDeviceAndInode & 0x3FFFFL;
            device = this.nextArtificalDeviceAndInode++ >> 18 & 0x3FFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, inode + 262144L * device) + 1L;
        }
        this.writeAsciiLong(device, 6, 8);
        this.writeAsciiLong(inode, 6, 8);
        this.writeAsciiLong(entry2.getMode(), 6, 8);
        this.writeAsciiLong(entry2.getUID(), 6, 8);
        this.writeAsciiLong(entry2.getGID(), 6, 8);
        this.writeAsciiLong(entry2.getNumberOfLinks(), 6, 8);
        this.writeAsciiLong(entry2.getRemoteDevice(), 6, 8);
        this.writeAsciiLong(entry2.getTime(), 11, 8);
        this.writeAsciiLong(entry2.getName().length() + 1, 6, 8);
        this.writeAsciiLong(entry2.getSize(), 11, 8);
        this.writeCString(entry2.getName());
    }

    private void writeOldBinaryEntry(CpioArchiveEntry entry2, boolean swapHalfWord) throws IOException {
        long inode = entry2.getInode();
        long device = entry2.getDevice();
        if ("TRAILER!!!".equals(entry2.getName())) {
            device = 0L;
            inode = 0L;
        } else if (inode == 0L && device == 0L) {
            inode = this.nextArtificalDeviceAndInode & 0xFFFFL;
            device = this.nextArtificalDeviceAndInode++ >> 16 & 0xFFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, inode + 65536L * device) + 1L;
        }
        this.writeBinaryLong(device, 2, swapHalfWord);
        this.writeBinaryLong(inode, 2, swapHalfWord);
        this.writeBinaryLong(entry2.getMode(), 2, swapHalfWord);
        this.writeBinaryLong(entry2.getUID(), 2, swapHalfWord);
        this.writeBinaryLong(entry2.getGID(), 2, swapHalfWord);
        this.writeBinaryLong(entry2.getNumberOfLinks(), 2, swapHalfWord);
        this.writeBinaryLong(entry2.getRemoteDevice(), 2, swapHalfWord);
        this.writeBinaryLong(entry2.getTime(), 4, swapHalfWord);
        this.writeBinaryLong(entry2.getName().length() + 1, 2, swapHalfWord);
        this.writeBinaryLong(entry2.getSize(), 4, swapHalfWord);
        this.writeCString(entry2.getName());
        this.pad(entry2.getHeaderPadCount());
    }

    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        this.ensureOpen();
        if (this.entry == null) {
            throw new IOException("Trying to close non-existent entry");
        }
        if (this.entry.getSize() != this.written) {
            throw new IOException("invalid entry size (expected " + this.entry.getSize() + " but got " + this.written + " bytes)");
        }
        this.pad(this.entry.getDataPadCount());
        if (this.entry.getFormat() == 2 && this.crc != this.entry.getChksum()) {
            throw new IOException("CRC Error");
        }
        this.entry = null;
        this.crc = 0L;
        this.written = 0L;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.entry == null) {
            throw new IOException("no current CPIO entry");
        }
        if (this.written + (long)len > this.entry.getSize()) {
            throw new IOException("attempt to write past end of STORED entry");
        }
        this.out.write(b, off, len);
        this.written += (long)len;
        if (this.entry.getFormat() == 2) {
            for (int pos = 0; pos < len; ++pos) {
                this.crc += (long)(b[pos] & 0xFF);
            }
        }
        this.count(len);
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.entry = new CpioArchiveEntry(this.entryFormat);
        this.entry.setName("TRAILER!!!");
        this.entry.setNumberOfLinks(1L);
        this.writeHeader(this.entry);
        this.closeArchiveEntry();
        int lengthOfLastBlock = (int)(this.getBytesWritten() % (long)this.blockSize);
        if (lengthOfLastBlock != 0) {
            this.pad(this.blockSize - lengthOfLastBlock);
        }
        this.finished = true;
    }

    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        if (!this.closed) {
            this.out.close();
            this.closed = true;
        }
    }

    private void pad(int count2) throws IOException {
        if (count2 > 0) {
            byte[] buff = new byte[count2];
            this.out.write(buff);
            this.count(count2);
        }
    }

    private void writeBinaryLong(long number2, int length, boolean swapHalfWord) throws IOException {
        byte[] tmp = CpioUtil.long2byteArray(number2, length, swapHalfWord);
        this.out.write(tmp);
        this.count(tmp.length);
    }

    private void writeAsciiLong(long number2, int length, int radix) throws IOException {
        String tmpStr;
        StringBuilder tmp = new StringBuilder();
        if (radix == 16) {
            tmp.append(Long.toHexString(number2));
        } else if (radix == 8) {
            tmp.append(Long.toOctalString(number2));
        } else {
            tmp.append(Long.toString(number2));
        }
        if (tmp.length() <= length) {
            long insertLength = length - tmp.length();
            int pos = 0;
            while ((long)pos < insertLength) {
                tmp.insert(0, "0");
                ++pos;
            }
            tmpStr = tmp.toString();
        } else {
            tmpStr = tmp.substring(tmp.length() - length);
        }
        byte[] b = ArchiveUtils.toAsciiBytes(tmpStr);
        this.out.write(b);
        this.count(b.length);
    }

    private void writeCString(String str) throws IOException {
        ByteBuffer buf = this.encoding.encode(str);
        int len = buf.limit() - buf.position();
        this.out.write(buf.array(), buf.arrayOffset(), len);
        this.out.write(0);
        this.count(len + 1);
    }

    public ArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new CpioArchiveEntry(inputFile, entryName);
    }
}

