/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.SharedKeyProvider;
import net.java.truecommons.shed.UniqueObject;

@ThreadSafe
final class SharedKeyManager<K extends PromptingKey<K>>
extends UniqueObject {
    private final Map<URI, SharedKeyProvider<K>> providers = new HashMap<URI, SharedKeyProvider<K>>();

    SharedKeyManager() {
    }

    @CheckForNull
    private SharedKeyProvider<K> get(URI resource) {
        return this.providers.get(Objects.requireNonNull(resource));
    }

    synchronized SharedKeyProvider<K> provider(URI resource) {
        SharedKeyProvider<K> p = this.get(resource);
        if (null == p) {
            p = new SharedKeyProvider();
            this.providers.put(resource, p);
        }
        return p;
    }

    synchronized void link(URI oldResource, URI newResource) {
        Objects.requireNonNull(newResource);
        SharedKeyProvider<K> p = this.get(oldResource);
        if (null != p) {
            this.providers.put(newResource, p);
        }
    }

    synchronized void unlink(URI resource) {
        SharedKeyProvider<Object> p = this.providers.remove(Objects.requireNonNull(resource));
        if (null != p) {
            p.setKeyClone(null);
        }
    }

    synchronized void resetCancelledKey(URI resource) {
        SharedKeyProvider<K> p = this.get(resource);
        if (null != p) {
            p.resetCancelledKey();
        }
    }

    synchronized void resetUnconditionally(URI resource) {
        SharedKeyProvider<K> p = this.get(resource);
        if (null != p) {
            p.resetUnconditionally();
        }
    }
}

