/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import net.java.truecommons.io.AbstractSeekableChannel;

public abstract class DecoratingSeekableChannel
extends AbstractSeekableChannel {
    @Nullable
    @WillCloseWhenClosed
    protected SeekableByteChannel channel;

    protected DecoratingSeekableChannel() {
    }

    protected DecoratingSeekableChannel(@WillCloseWhenClosed SeekableByteChannel channel2) {
        this.channel = Objects.requireNonNull(channel2);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size2) throws IOException {
        this.channel.truncate(size2);
        return this;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.channel.close();
    }

    public String toString() {
        return String.format("%s[channel=%s]", this.getClass().getName(), this.channel);
    }
}

