/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;

@NotThreadSafe
public final class CipherOutputStream
extends DecoratingOutputStream {
    @CheckForNull
    private BufferedBlockCipher cipher;
    private byte[] buffer = new byte[0];

    @CreatesObligation
    public CipherOutputStream(BufferedBlockCipher cipher, @WillCloseWhenClosed OutputStream out) {
        super(Objects.requireNonNull(out));
        this.cipher = Objects.requireNonNull(cipher);
    }

    private BufferedBlockCipher cipher() throws IOException {
        BufferedBlockCipher cipher = this.cipher;
        if (null == cipher) {
            throw new IOException("Cipher output stream has been closed!");
        }
        return cipher;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] cipherOut;
        BufferedBlockCipher cipher = this.cipher();
        int cipherLen = cipher.getUpdateOutputSize(1);
        if (cipherLen > (cipherOut = this.buffer).length) {
            this.buffer = cipherOut = new byte[cipherLen];
        }
        if ((cipherLen = cipher.processByte((byte)b, cipherOut, 0)) > 0) {
            this.out.write(cipherOut, 0, cipherLen);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] cipherOut;
        BufferedBlockCipher cipher = this.cipher();
        int cipherLen = cipher.getUpdateOutputSize(len);
        if (cipherLen > (cipherOut = this.buffer).length) {
            this.buffer = cipherOut = new byte[cipherLen];
        }
        cipherLen = cipher.processBytes(buf, off, len, cipherOut, 0);
        this.out.write(cipherOut, 0, cipherLen);
    }

    public void finish() throws IOException {
        byte[] cipherOut;
        BufferedBlockCipher cipher = this.cipher;
        if (null == cipher) {
            return;
        }
        this.cipher = null;
        int cipherLen = cipher.getOutputSize(0);
        if (cipherLen > (cipherOut = this.buffer).length) {
            this.buffer = cipherOut = new byte[cipherLen];
        }
        try {
            cipherLen = cipher.doFinal(cipherOut, 0);
        }
        catch (InvalidCipherTextException ex) {
            throw new IOException(ex);
        }
        this.out.write(cipherOut, 0, cipherLen);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }
}

