/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;

@NotThreadSafe
public class LittleEndianOutputStream
extends DecoratingOutputStream {
    protected long written;
    private final byte[] buf = new byte[8];

    protected LittleEndianOutputStream() {
    }

    public LittleEndianOutputStream(@WillCloseWhenClosed OutputStream out) {
        super(out);
    }

    private void inc(int inc) {
        long s2 = this.written + (long)inc;
        this.written = s2 >= 0L ? s2 : Long.MAX_VALUE;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.inc(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.inc(len);
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
        this.inc(1);
    }

    public final void writeByte(int b) throws IOException {
        this.out.write(b);
        this.inc(1);
    }

    public final void writeShort(int s2) throws IOException {
        this.buf[0] = (byte)s2;
        this.buf[1] = (byte)(s2 >>= 8);
        this.out.write(this.buf, 0, 2);
        this.inc(2);
    }

    public final void writeChar(int c) throws IOException {
        this.writeShort(c);
    }

    public final void writeInt(int i) throws IOException {
        this.buf[0] = (byte)i;
        this.buf[1] = (byte)(i >>= 8);
        this.buf[2] = (byte)(i >>= 8);
        this.buf[3] = (byte)(i >>= 8);
        this.out.write(this.buf, 0, 4);
        this.inc(4);
    }

    public final void writeLong(long l) throws IOException {
        this.buf[0] = (byte)l;
        this.buf[1] = (byte)(l >>= 8);
        this.buf[2] = (byte)(l >>= 8);
        this.buf[3] = (byte)(l >>= 8);
        this.buf[4] = (byte)(l >>= 8);
        this.buf[5] = (byte)(l >>= 8);
        this.buf[6] = (byte)(l >>= 8);
        this.buf[7] = (byte)(l >>= 8);
        this.out.write(this.buf, 0, 8);
        this.inc(8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(s2.charAt(i));
        }
    }

    public final void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s2.charAt(i));
        }
    }

    public void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long size() {
        return this.written;
    }
}

