/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ImmutableBuffer;
import net.java.truecommons.io.PowerBuffer;

@NotThreadSafe
public final class MutableBuffer
extends PowerBuffer<MutableBuffer> {
    private MutableBuffer(ByteBuffer buf) {
        super(buf);
    }

    public static MutableBuffer allocateDirect(int capacity) {
        return new MutableBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static MutableBuffer allocate(int capacity) {
        return new MutableBuffer(ByteBuffer.allocate(capacity));
    }

    public static MutableBuffer wrap(byte[] array) {
        return new MutableBuffer(ByteBuffer.wrap(array));
    }

    public static MutableBuffer wrap(byte[] array, int offset, int length) {
        return new MutableBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public static MutableBuffer wrap(ByteBuffer buf) {
        return new MutableBuffer(Objects.requireNonNull(buf));
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public MutableBuffer asMutableBuffer() {
        return this;
    }

    @Override
    public ImmutableBuffer asImmutableBuffer() {
        return ImmutableBuffer.wrap(this.bb);
    }

    @Override
    public MutableBuffer slice() {
        return new MutableBuffer(this.bb.slice());
    }

    @Override
    public MutableBuffer duplicate() {
        return new MutableBuffer(this.bb.duplicate());
    }

    @Override
    public MutableBuffer asReadOnlyBuffer() {
        return new MutableBuffer(this.bb.asReadOnlyBuffer());
    }
}

