/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.cio;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.AbstractInputSocket;
import net.java.truecommons.cio.AbstractOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.ByteBufferChannel;
import net.java.truecommons.io.DisconnectingSeekableChannel;

@NotThreadSafe
public class MemoryBuffer
implements IoBuffer {
    private final String name;
    private int initialCapacity;
    @CheckForNull
    private ByteBuffer buffer;
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    private int reads;
    private int writes;

    public MemoryBuffer(String name, int initialCapacity) {
        this(name, null, initialCapacity);
    }

    public MemoryBuffer(String name, ByteBuffer buffer) {
        this(name, buffer, buffer.capacity());
    }

    private MemoryBuffer(String name, @CheckForNull ByteBuffer buffer, int initialCapacity) {
        this.name = Objects.requireNonNull(name);
        this.setBuffer(buffer);
        this.setInitialCapacity(initialCapacity);
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final void setInitialCapacity(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @Nullable
    public final ByteBuffer getBuffer() {
        return null != this.buffer ? this.buffer.duplicate() : null;
    }

    public final void setBuffer(@CheckForNull ByteBuffer buffer) {
        this.buffer = null != buffer ? (ByteBuffer)buffer.duplicate().rewind() : null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getSize(Entry.Size type) {
        return null != this.buffer ? (long)this.buffer.limit() : -1L;
    }

    public final int getCount(Entry.Access type) {
        return type == Entry.Access.WRITE ? this.writes : this.reads;
    }

    @Override
    public final long getTime(Entry.Access type) {
        Long time = this.times.get((Object)type);
        return null != time ? time : -1L;
    }

    @Override
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return true;
    }

    @Override
    public final InputSocket<MemoryBuffer> input() {
        return new Input();
    }

    @Override
    public final OutputSocket<MemoryBuffer> output() {
        return new Output();
    }

    @Override
    public void release() throws IOException {
        this.buffer = null;
    }

    public String toString() {
        return String.format("%s[name=%s]", this.getClass().getName(), this.getName());
    }

    private final class DataOutputChannel
    extends DisconnectingSeekableChannel {
        boolean closed;

        @CreatesObligation
        DataOutputChannel() {
            ByteBuffer buffer = (ByteBuffer)ByteBuffer.allocateDirect(MemoryBuffer.this.initialCapacity).limit(0);
            this.channel = new ByteBufferChannel(buffer);
            MemoryBuffer.this.writes++;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            MemoryBuffer.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            MemoryBuffer.this.buffer = (ByteBuffer)((ByteBufferChannel)this.channel).getBuffer().rewind();
            this.closed = true;
        }
    }

    private final class DataInputChannel
    extends DisconnectingSeekableChannel {
        boolean closed;

        @CreatesObligation
        DataInputChannel() throws FileNotFoundException {
            ByteBuffer buffer = MemoryBuffer.this.buffer;
            if (null == buffer) {
                throw new FileNotFoundException();
            }
            this.channel = new ByteBufferChannel(buffer.asReadOnlyBuffer());
            MemoryBuffer.this.reads++;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            MemoryBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private final class Output
    extends AbstractOutputSocket<MemoryBuffer> {
        private Output() {
        }

        @Override
        public MemoryBuffer target() throws IOException {
            return MemoryBuffer.this;
        }

        @Override
        public SeekableByteChannel channel(InputSocket<? extends Entry> peer) throws IOException {
            return new DataOutputChannel();
        }
    }

    private final class Input
    extends AbstractInputSocket<MemoryBuffer> {
        private Input() {
        }

        @Override
        public MemoryBuffer target() throws IOException {
            return MemoryBuffer.this;
        }

        @Override
        public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
            return new DataInputChannel();
        }
    }
}

