/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.inst;

import java.util.Objects;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truevfs.comp.inst.Mediator;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;

@Immutable
public class InstrumentingCompositeDriver<M extends Mediator<M>>
implements FsCompositeDriver {
    protected final M mediator;
    protected final FsCompositeDriver driver;

    public InstrumentingCompositeDriver(M mediator, FsCompositeDriver driver) {
        this.mediator = (Mediator)Objects.requireNonNull(mediator);
        this.driver = Objects.requireNonNull(driver);
    }

    @Override
    public final FsModel newModel(FsManager context, FsMountPoint mountPoint, FsModel parent) {
        assert (null != parent ? parent.getMountPoint().equals(mountPoint.getParent()) : null == mountPoint.getParent());
        return ((Mediator)this.mediator).instrument(this, this.driver.newModel(context, mountPoint, parent));
    }

    @Override
    public FsController newController(FsManager context, FsModel model, @CheckForNull FsController parent) throws ServiceConfigurationError {
        assert (null != parent ? parent.getModel().equals(model.getParent()) : null == model.getParent());
        return ((Mediator)this.mediator).instrument(this, this.driver.newController(context, model, parent));
    }

    public String toString() {
        return String.format("%s[driver=%s]", this.getClass().getName(), this.driver);
    }
}

