/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.hurlfb;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.truecommons.key.swing.feedback.DecoratingFeedback;
import net.java.truecommons.key.swing.feedback.Feedback;

final class HurlingWindowFeedback
extends DecoratingFeedback
implements Feedback {
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    private static final double amplitude = 25.0;
    private static final double cycle = 150.0;
    private static final int duration = 1500;
    private static final int fps = 75;

    HurlingWindowFeedback(Feedback feedback) {
        super(feedback);
    }

    @Override
    public void run(JPanel panel) {
        this.feedback.run(panel);
        final Window window = SwingUtilities.getWindowAncestor(panel);
        if (null == window) {
            return;
        }
        final Point origin = window.getLocation();
        final long start = System.currentTimeMillis();
        Timer timer = new Timer(13, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed < 1500L && window.isShowing()) {
                    double angle = Math.PI * 2 * (double)elapsed / 150.0;
                    double offset = Math.sin(Math.PI * (double)elapsed / 1500.0) * 25.0;
                    int x = (int)(Math.cos(angle) * offset + (double)origin.x);
                    int y = (int)(Math.sin(angle) * offset + (double)origin.y);
                    window.setLocation(x, y);
                    window.repaint();
                } else {
                    ((Timer)e.getSource()).stop();
                    window.setLocation(origin);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

