/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Union
extends Structure {
    private Structure.StructField activeField;
    Structure.StructField biggestField;

    protected Union() {
    }

    protected Union(Pointer p) {
        super(p);
    }

    protected Union(Pointer p, int alignType) {
        super(p, alignType);
    }

    protected Union(TypeMapper mapper) {
        super(mapper);
    }

    protected Union(Pointer p, int alignType, TypeMapper mapper) {
        super(p, alignType, mapper);
    }

    protected List getFieldOrder() {
        List flist = this.getFieldList();
        ArrayList<String> list2 = new ArrayList<String>();
        Iterator i = flist.iterator();
        while (i.hasNext()) {
            Field f = (Field)i.next();
            list2.add(f.getName());
        }
        return list2;
    }

    public void setType(Class type) {
        this.ensureAllocated();
        Iterator i = this.fields().values().iterator();
        while (i.hasNext()) {
            Structure.StructField f = (Structure.StructField)i.next();
            if (f.type != type) continue;
            this.activeField = f;
            return;
        }
        throw new IllegalArgumentException("No field of type " + type + " in " + this);
    }

    public void setType(String fieldName) {
        this.ensureAllocated();
        Structure.StructField f = (Structure.StructField)this.fields().get(fieldName);
        if (f == null) {
            throw new IllegalArgumentException("No field named " + fieldName + " in " + this);
        }
        this.activeField = f;
    }

    public Object readField(String fieldName) {
        this.ensureAllocated();
        this.setType(fieldName);
        return super.readField(fieldName);
    }

    public void writeField(String fieldName) {
        this.ensureAllocated();
        this.setType(fieldName);
        super.writeField(fieldName);
    }

    public void writeField(String fieldName, Object value2) {
        this.ensureAllocated();
        this.setType(fieldName);
        super.writeField(fieldName, value2);
    }

    public Object getTypedValue(Class type) {
        this.ensureAllocated();
        Iterator i = this.fields().values().iterator();
        while (i.hasNext()) {
            Structure.StructField f = (Structure.StructField)i.next();
            if (f.type != type) continue;
            this.activeField = f;
            this.read();
            return this.getFieldValue(this.activeField.field);
        }
        throw new IllegalArgumentException("No field of type " + type + " in " + this);
    }

    public Object setTypedValue(Object object) {
        Structure.StructField f = this.findField(object.getClass());
        if (f != null) {
            this.activeField = f;
            this.setFieldValue(f.field, object);
            return this;
        }
        throw new IllegalArgumentException("No field of type " + object.getClass() + " in " + this);
    }

    private Structure.StructField findField(Class type) {
        this.ensureAllocated();
        Iterator i = this.fields().values().iterator();
        while (i.hasNext()) {
            Structure.StructField f = (Structure.StructField)i.next();
            if (!f.type.isAssignableFrom(type)) continue;
            return f;
        }
        return null;
    }

    void writeField(Structure.StructField field2) {
        if (field2 == this.activeField) {
            super.writeField(field2);
        }
    }

    Object readField(Structure.StructField field2) {
        if (field2 == this.activeField || !Structure.class.isAssignableFrom(field2.type) && !String.class.isAssignableFrom(field2.type) && !WString.class.isAssignableFrom(field2.type)) {
            return super.readField(field2);
        }
        return null;
    }

    int calculateSize(boolean force2, boolean avoidFFIType) {
        int size2 = super.calculateSize(force2, avoidFFIType);
        if (size2 != -1) {
            int fsize = 0;
            Iterator i = this.fields().values().iterator();
            while (i.hasNext()) {
                Structure.StructField f = (Structure.StructField)i.next();
                f.offset = 0;
                if (f.size <= fsize && (f.size != fsize || !(class$com$sun$jna$Structure == null ? Union.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(f.type))) continue;
                fsize = f.size;
                this.biggestField = f;
            }
            size2 = this.calculateAlignedSize(fsize);
            if (size2 > 0 && this instanceof Structure.ByValue && !avoidFFIType) {
                this.getTypeInfo();
            }
        }
        return size2;
    }

    protected int getNativeAlignment(Class type, Object value2, boolean isFirstElement) {
        return super.getNativeAlignment(type, value2, true);
    }

    Pointer getTypeInfo() {
        if (this.biggestField == null) {
            return null;
        }
        return super.getTypeInfo();
    }
}

