/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.tardriver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.shed.Releasable;
import net.java.truevfs.kernel.spec.FsArchiveEntries;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarDriverEntry
extends TarArchiveEntry
implements FsArchiveEntry,
Releasable<IOException> {
    private static final int SIZE = 1;
    private static final int MODTIME = 2;
    private static final int TUREAD = 256;
    private static final int TUWRITE = 128;
    private static final int TUEXEC = 64;
    private static final int TGREAD = 32;
    private static final int TGWRITE = 16;
    private static final int TGEXEC = 8;
    private static final int TOREAD = 4;
    private static final int TOWRITE = 2;
    private static final int TOEXEC = 1;
    private byte init;
    @CheckForNull
    private IoBuffer buffer;

    public TarDriverEntry(String name) {
        super(name, true);
        super.setUserName(System.getProperty("user.name", "TrueVFS"));
    }

    protected TarDriverEntry(String name, TarArchiveEntry template) {
        super(name, true);
        super.setMode(template.getMode());
        this.setModTime0(template.getModTime().getTime());
        this.setSize0(template.getSize());
        super.setUserId(template.getUserId());
        super.setUserName(template.getUserName());
        super.setGroupId(template.getGroupId());
        super.setGroupName(template.getGroupName());
        super.setLinkName(template.getLinkName());
        super.setDevMajor(template.getDevMajor());
        super.setDevMinor(template.getDevMinor());
    }

    private boolean isInit(int mask) {
        return 0 != (this.init & mask);
    }

    private void setInit(int mask, boolean init2) {
        this.init = init2 ? (byte)(this.init | mask) : (byte)(this.init & ~mask);
    }

    @Nullable
    IoBuffer getBuffer() {
        return this.buffer;
    }

    void setBuffer(@CheckForNull IoBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void release() throws IOException {
        if (null != this.buffer) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    public long getSize() {
        return this.isInit(1) ? super.getSize() : -1L;
    }

    @Override
    public void setSize(long size2) {
        this.setSize0(size2);
    }

    private void setSize0(long size2) {
        boolean known = -1L != size2;
        super.setSize(known ? size2 : 0L);
        this.setInit(1, known);
    }

    @Override
    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: 
            case STORAGE: {
                return this.getSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size type, long size2) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size2);
        return true;
    }

    @Override
    public Date getModTime() {
        return this.isInit(2) ? super.getModTime() : new Date(-1L);
    }

    @Override
    public void setModTime(long time) {
        this.setModTime0(time);
    }

    private void setModTime0(long time) {
        boolean known = -1L != time;
        super.setModTime(known ? time : 0L);
        this.setInit(2, known);
    }

    @Override
    public void setModTime(Date time) {
        this.setModTime(time.getTime());
    }

    @Override
    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getModTime().getTime();
        return 0L <= time ? time : -1L;
    }

    @Override
    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setModTime(time);
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        if (!(entity instanceof Entry.PosixEntity)) {
            return null;
        }
        switch ((Entry.PosixEntity)entity) {
            case USER: {
                switch (type) {
                    case READ: {
                        return 0 != (super.getMode() & 0x100);
                    }
                    case WRITE: {
                        return 0 != (super.getMode() & 0x80);
                    }
                    case EXECUTE: {
                        return 0 != (super.getMode() & 0x40);
                    }
                }
                break;
            }
            case GROUP: {
                switch (type) {
                    case READ: {
                        return 0 != (super.getMode() & 0x20);
                    }
                    case WRITE: {
                        return 0 != (super.getMode() & 0x10);
                    }
                    case EXECUTE: {
                        return 0 != (super.getMode() & 8);
                    }
                }
                break;
            }
            case OTHER: {
                switch (type) {
                    case READ: {
                        return 0 != (super.getMode() & 4);
                    }
                    case WRITE: {
                        return 0 != (super.getMode() & 2);
                    }
                    case EXECUTE: {
                        return 0 != (super.getMode() & 1);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean setPermitted(Entry.Access type, Entry.Entity entity, Boolean value2) {
        if (null == value2 || !(entity instanceof Entry.PosixEntity)) {
            return false;
        }
        switch ((Entry.PosixEntity)entity) {
            case USER: {
                switch (type) {
                    case READ: {
                        super.setMode(value2 != false ? super.getMode() | 0x100 : super.getMode() & 0xFFFFFEFF);
                        return true;
                    }
                    case WRITE: {
                        super.setMode(value2 != false ? super.getMode() | 0x80 : super.getMode() & 0xFFFFFF7F);
                        return true;
                    }
                    case EXECUTE: {
                        super.setMode(value2 != false ? super.getMode() | 0x40 : super.getMode() & 0xFFFFFFBF);
                        return true;
                    }
                }
                break;
            }
            case GROUP: {
                switch (type) {
                    case READ: {
                        super.setMode(value2 != false ? super.getMode() | 0x20 : super.getMode() & 0xFFFFFFDF);
                        return true;
                    }
                    case WRITE: {
                        super.setMode(value2 != false ? super.getMode() | 0x10 : super.getMode() & 0xFFFFFFEF);
                        return true;
                    }
                    case EXECUTE: {
                        super.setMode(value2 != false ? super.getMode() | 8 : super.getMode() & 0xFFFFFFF7);
                        return true;
                    }
                }
                break;
            }
            case OTHER: {
                switch (type) {
                    case READ: {
                        super.setMode(value2 != false ? super.getMode() | 4 : super.getMode() & 0xFFFFFFFB);
                        return true;
                    }
                    case WRITE: {
                        super.setMode(value2 != false ? super.getMode() | 2 : super.getMode() & 0xFFFFFFFD);
                        return true;
                    }
                    case EXECUTE: {
                        super.setMode(value2 != false ? super.getMode() | 1 : super.getMode() & 0xFFFFFFFE);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

