/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.cio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.InputException;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Source;
import net.java.truecommons.io.Streams;

@Immutable
public final class IoSockets {
    private IoSockets() {
    }

    public static void copy(InputSocket<?> input2, OutputSocket<?> output2) throws InputException, IOException {
        Streams.copy(new InputAdapter(input2, output2), new OutputAdapter(output2, input2));
    }

    private static class OutputAdapter
    implements Sink {
        final OutputSocket<? extends Entry> output;
        final InputSocket<? extends Entry> input;

        OutputAdapter(OutputSocket<? extends Entry> output2, InputSocket<? extends Entry> input2) {
            this.output = output2;
            this.input = input2;
        }

        @Override
        public OutputStream stream() throws IOException {
            return this.output.stream(this.input);
        }

        @Override
        public SeekableByteChannel channel() throws IOException {
            return this.output.channel(this.input);
        }
    }

    private static class InputAdapter
    implements Source {
        final InputSocket<? extends Entry> input;
        final OutputSocket<? extends Entry> output;

        InputAdapter(InputSocket<? extends Entry> input2, OutputSocket<? extends Entry> output2) {
            this.input = input2;
            this.output = output2;
        }

        @Override
        public InputStream stream() throws IOException {
            return this.input.stream(this.output);
        }

        @Override
        public SeekableByteChannel channel() throws IOException {
            return this.input.channel(this.output);
        }
    }
}

