/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.UniqueObject;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;

@ThreadSafe
public abstract class FsAbstractModel
extends UniqueObject
implements FsModel {
    private final FsMountPoint mountPoint;
    @CheckForNull
    private final FsModel parent;

    protected FsAbstractModel(FsMountPoint mountPoint, @CheckForNull FsModel parent) {
        if (!Objects.equals(mountPoint.getParent(), null == parent ? null : parent.getMountPoint())) {
            throw new IllegalArgumentException("Parent/Member mismatch!");
        }
        this.mountPoint = mountPoint;
        this.parent = parent;
    }

    @Override
    public final FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    @Override
    @CheckForNull
    public final FsModel getParent() {
        return this.parent;
    }

    public String toString() {
        return String.format("%s@%x[mountPoint=%s, parent=%s, mounted=%b]", this.getClass().getName(), this.hashCode(), this.mountPoint, this.parent, this.isMounted());
    }
}

