/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import net.java.truecommons.io.DecoratingOutputStream;

abstract class IOExceptionOutputStream
extends DecoratingOutputStream {
    @CheckForNull
    IOException exception;

    @CreatesObligation
    IOExceptionOutputStream(@WillCloseWhenClosed OutputStream out) {
        super(out);
    }

    public void write(int b) throws IOException {
        try {
            this.out.write(b);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }
}

