/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.zip.io.ZipOutput;

public final class ZipEntrySink
implements Sink {
    private final ZipEntry entry;
    private final ZipOutput output;

    public ZipEntrySink(ZipEntry entry, ZipOutput output) {
        this.entry = Objects.requireNonNull(entry);
        this.output = Objects.requireNonNull(output);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean directory() {
        return this.entry.isDirectory();
    }

    @Override
    public OutputStream output() throws IOException {
        if (this.directory()) {
            this.entry.setMethod(0);
            this.entry.setSize(0L);
            this.entry.setCompressedSize(0L);
            this.entry.setCrc(0L);
        }
        return this.output.stream(this.entry);
    }
}

