/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.WithInputTask;

@Immutable
public class Sources {
    public static Source forResource(final String name, final @Nullable ClassLoader loader) {
        Objects.requireNonNull(name);
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return this.check(null != loader ? loader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name), name);
            }

            InputStream check(@Nullable InputStream in, String name2) throws FileNotFoundException {
                if (null == in) {
                    throw new FileNotFoundException(String.format("Could not locate resource %s on the class path.", name2));
                }
                return in;
            }
        };
    }

    public static <V, X extends Exception> ExecuteStatement<V, X> execute(InputTask<V, X> task) {
        return new WithInputTask<V, X>(task);
    }

    private Sources() {
    }

    public static interface ExecuteStatement<V, X extends Exception> {
        public V on(File var1) throws X, IOException;

        public V on(Source var1) throws X, IOException;
    }
}

