/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import net.java.trueupdate.core.io.Store;

public final class FileStore
implements Store {
    private final File file;

    public FileStore(File file) {
        this.file = Objects.requireNonNull(file);
    }

    @Override
    public InputStream input() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream output() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public void delete() throws IOException {
        if (!this.file.delete()) {
            throw new FileNotFoundException(this.file + " (could not delete)");
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

