/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.OutputTask;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Sinks;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.Sources;
import net.java.trueupdate.core.io.ThreadGroups;

@Immutable
public final class Copy {
    static final int FIFO_SIZE = 4;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ReaderThreadFactory());

    public static void copy(Source source, Sink sink) throws IOException {
        class SourceTask
        implements InputTask<Void, IOException> {
            final /* synthetic */ Sink val$sink;

            SourceTask(Sink sink) {
                this.val$sink = sink;
            }

            @Override
            public Void execute(final InputStream in) throws IOException {
                class SinkTask
                implements OutputTask<Void, IOException> {
                    SinkTask() {
                    }

                    @Override
                    public Void execute(OutputStream out) throws IOException {
                        Copy.cat(in, out);
                        return null;
                    }
                }
                return Sinks.execute(new SinkTask()).on(this.val$sink);
            }
        }
        Sources.execute(new SourceTask(sink)).on(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void cat(final @WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        Objects.requireNonNull(in);
        Objects.requireNonNull(out);
        lock = new ReentrantLock();
        signal = lock.newCondition();
        buffers = Buffer.allocate();
        interrupted = false;
        try {
            reader = new ReaderTask();
            result = Copy.executor.submit(reader);
            buffersLength = buffers.length;
            while (true) lbl-1000:
            // 3 sources

            {
                lock.lock();
                try {
                    while (0 >= reader.size) {
                        try {
                            signal.await();
                        }
                        catch (InterruptedException interrupt) {
                            interrupted = true;
                        }
                    }
                    off = reader.off;
                    buffer = buffers[off];
                }
                finally {
                    lock.unlock();
                }
                write = buffer.read;
                if (0 > write) ** break;
                try {
                    out.write(buffer.buf, 0, write);
                }
                catch (IOException ex) {
                    Copy.cancel(result);
                    throw ex;
                }
                lock.lock();
                try {
                    reader.off = (off + 1) % buffersLength;
                    --reader.size;
                    signal.signal();
                }
                finally {
                    lock.unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            out.flush();
            t = reader.exception;
            if (null != t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (Error)t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            Buffer.release(buffers);
        }
    }

    private static void cancel(Future<?> result) {
        result.cancel(true);
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    result.get();
                }
                catch (CancellationException cancelled) {
                }
                catch (ExecutionException cannotHappen) {
                    throw new AssertionError((Object)cannotHappen);
                }
                catch (InterruptedException interrupt) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Copy() {
    }

    public static final class ReaderThread
    extends Thread {
        private ReaderThread(Runnable r) {
            super(ThreadGroups.getServerThreadGroup(), r, ReaderThread.class.getName());
            this.setDaemon(true);
        }
    }

    private static final class ReaderThreadFactory
    implements ThreadFactory {
        private ReaderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new ReaderThread(r);
        }
    }

    private static final class Buffer {
        static final Queue<Reference<Buffer[]>> queue = new ConcurrentLinkedQueue<Reference<Buffer[]>>();
        final byte[] buf = new byte[8192];
        int read;

        private Buffer() {
        }

        static Buffer[] allocate() {
            Reference<Buffer[]> reference;
            while (null != (reference = queue.poll())) {
                Buffer[] buffers = reference.get();
                if (null == buffers) continue;
                return buffers;
            }
            Buffer[] buffers = new Buffer[4];
            int i = buffers.length;
            while (0 <= --i) {
                buffers[i] = new Buffer();
            }
            return buffers;
        }

        static void release(Buffer[] buffers) {
            queue.add(new SoftReference<Buffer[]>(buffers));
        }
    }
}

