/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.relaxng;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.reader.ExpressionState;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.util.StartTagInfo;
import com.sun.tahiti.grammar.AccessModifier;
import com.sun.tahiti.grammar.Accessor;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.CollectionType;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.SuperClassItem;
import com.sun.tahiti.reader.NameUtil;
import com.sun.tahiti.reader.TahitiGrammarReader;
import com.sun.tahiti.reader.annotator.Annotator;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TRELAXNGReader
extends RELAXNGReader
implements TahitiGrammarReader {
    private final AnnotatedGrammar annGrammar;
    private final Stack packageNameStack;
    private String defaultPackageName;
    public static final String ERR_UNDEFINED_ROLE = "UndefinedRole";
    public static final String ERR_NAME_NEEDED = "NameNeeded";

    public TRELAXNGReader(GrammarReaderController controller, SAXParserFactory parserFactory, RELAXNGReader.StateFactory stateFactory, ExpressionPool pool) {
        super(controller, parserFactory, stateFactory, pool);
        this.annGrammar = new AnnotatedGrammar(null, this.pool);
        this.packageNameStack = new Stack();
        this.defaultPackageName = "";
    }

    public TRELAXNGReader(GrammarReaderController controller, SAXParserFactory parserFactory) {
        super(controller, parserFactory);
        this.annGrammar = new AnnotatedGrammar(null, this.pool);
        this.packageNameStack = new Stack();
        this.defaultPackageName = "";
    }

    @Override
    public AnnotatedGrammar getAnnotatedResult() {
        return this.annGrammar;
    }

    protected Expression interceptExpression(ExpressionState state, Expression exp) {
        JavaItem roleExp;
        StartTagInfo tag = state.getStartTag();
        String role = tag.getAttribute("http://www.sun.com/xml/tahiti/", "role");
        if (role == null) {
            if (tag.localName.equals("element")) {
                String baseName = this.decideName(state, (Expression)exp, "class");
                if (this.annGrammar.classes.containsKey(baseName)) {
                    int cnt = 2;
                    while (this.annGrammar.classes.containsKey(baseName + cnt)) {
                        ++cnt;
                    }
                    baseName = baseName + cnt;
                }
                ClassItem t = this.annGrammar.createClassItem(baseName, (Expression)exp);
                t.isTemporary = true;
                return t;
            }
            return exp;
        }
        if (role.equals("none")) {
            return exp;
        }
        if (role.equals("superClass")) {
            roleExp = new SuperClassItem();
        } else if (role.equals("class")) {
            roleExp = this.annGrammar.createClassItem(this.decideName(state, (Expression)exp, role), null);
        } else if (role.equals("field")) {
            String method;
            String access;
            FieldItem fi = new FieldItem(this.decideName(state, (Expression)exp, role));
            roleExp = fi;
            String collection = tag.getAttribute("http://www.sun.com/xml/tahiti/", "collection");
            if (collection != null) {
                CollectionType cfr_ignored_0 = fi.collectionType;
                fi.collectionType = CollectionType.parse(collection);
                if (fi.collectionType == null) {
                    this.reportError("InvalidCollectionType", collection);
                }
            }
            if ((access = tag.getAttribute("http://www.sun.com/xml/tahiti/", "access")) != null) {
                AccessModifier cfr_ignored_1 = fi.accessModifier;
                fi.accessModifier = AccessModifier.parse(access);
                if (fi.accessModifier == null) {
                    this.reportError("InvalidAccessModifier", access);
                }
            }
            if ((method = tag.getAttribute("http://www.sun.com/xml/tahiti/", "method")) != null) {
                Accessor cfr_ignored_2 = fi.accessor;
                fi.accessor = Accessor.parse(method);
                if (fi.accessModifier == null) {
                    this.reportError("InvalidAccessor", method);
                }
            }
        } else if (role.equals("interface")) {
            roleExp = this.annGrammar.createInterfaceItem(this.decideName(state, (Expression)exp, role), null);
        } else if (role.equals("ignore")) {
            roleExp = new IgnoreItem();
        } else {
            this.reportError(ERR_UNDEFINED_ROLE, role);
            return exp;
        }
        this.setDeclaredLocationOf((Object)roleExp);
        if (tag.localName.equals("define")) {
            ReferenceExp rexp = (ReferenceExp)exp;
            roleExp.exp = rexp.exp;
            rexp.exp = roleExp;
        } else {
            roleExp.exp = exp;
            exp = roleExp;
        }
        return exp;
    }

    protected String decideName(ExpressionState state, Expression exp, String role) {
        int idx;
        NameClass nc;
        StartTagInfo tag = state.getStartTag();
        String name = tag.getAttribute("http://www.sun.com/xml/tahiti/", "name");
        if (name == null && (name = tag.getAttribute("name")) != null) {
            name = NameUtil.xmlNameToJavaName(role, name);
        }
        if (name == null && exp instanceof NameClassAndExpression && (nc = ((NameClassAndExpression)exp).getNameClass()) instanceof SimpleNameClass) {
            name = NameUtil.xmlNameToJavaName(role, ((SimpleNameClass)nc).localName);
        }
        if (name == null) {
            this.reportError(ERR_NAME_NEEDED);
            return "";
        }
        if ((role.equals("class") || role.equals("interface")) && (idx = name.indexOf(46)) < 0 && this.defaultPackageName.length() != 0) {
            name = this.defaultPackageName + "." + name;
        }
        return name;
    }

    public void wrapUp() {
        super.wrapUp();
        if (this.annGrammar.grammarName == null) {
            this.annGrammar.grammarName = "Grammar";
        }
        this.annGrammar.topLevel = this.grammar.exp;
        Annotator.annotate(this.annGrammar, (GrammarReader)this);
        this.grammar.exp = this.annGrammar.topLevel;
    }

    public void startElement(String a, String b, String c, Attributes d) throws SAXException {
        this.packageNameStack.push(this.defaultPackageName);
        if (d.getIndex("http://www.sun.com/xml/tahiti/", "package") != -1) {
            this.defaultPackageName = d.getValue("http://www.sun.com/xml/tahiti/", "package");
            if (this.annGrammar.grammarName == null) {
                this.annGrammar.grammarName = this.defaultPackageName + ".Grammar";
            }
        }
        super.startElement(a, b, c, d);
    }

    public void endElement(String a, String b, String c) throws SAXException {
        super.endElement(a, b, c);
        this.defaultPackageName = (String)this.packageNameStack.pop();
    }

    protected String localizeMessage(String propertyName, Object[] args) {
        String format;
        try {
            format = ResourceBundle.getBundle("com.sun.tahiti.reader.relaxng.Messages").getString(propertyName);
        }
        catch (Exception e) {
            try {
                format = ResourceBundle.getBundle("com.sun.tahiti.reader.Messages").getString(propertyName);
            }
            catch (Exception ee) {
                return super.localizeMessage(propertyName, args);
            }
        }
        return MessageFormat.format(format, args);
    }
}

