/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.annotator;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.tahiti.grammar.PrimitiveItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.Datatype;

class PrimitiveTypeAnnotator
extends ExpressionCloner {
    private final Set visitedExps = new HashSet();
    private final Map primitiveItems = new HashMap();

    PrimitiveTypeAnnotator(ExpressionPool pool) {
        super(pool);
    }

    public Expression onRef(ReferenceExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.exp = exp.exp.visit((ExpressionVisitorExpression)this);
        }
        return exp;
    }

    public Expression onOther(OtherExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.exp = exp.exp.visit((ExpressionVisitorExpression)this);
        }
        return exp;
    }

    public Expression onElement(ElementExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.contentModel = exp.contentModel.visit((ExpressionVisitorExpression)this);
        }
        return exp;
    }

    public Expression onAttribute(AttributeExp exp) {
        if (this.visitedExps.contains(exp)) {
            return exp;
        }
        Expression e = this.pool.createAttribute(exp.nameClass, exp.exp.visit((ExpressionVisitorExpression)this), exp.getDefaultValue());
        this.visitedExps.add(e);
        return e;
    }

    public Expression onAnyString() {
        return new PrimitiveItem((DatabindableDatatype)StringType.theInstance, this.pool.createData((XSDatatype)StringType.theInstance));
    }

    public Expression onValue(ValueExp exp) {
        return this.onDataOrValue((DataOrValueExp)exp);
    }

    public Expression onData(DataExp exp) {
        return this.onDataOrValue((DataOrValueExp)exp);
    }

    private Expression onDataOrValue(DataOrValueExp exp) {
        if (this.primitiveItems.containsKey(exp)) {
            return (Expression)this.primitiveItems.get(exp);
        }
        Datatype dt = exp.getType();
        PrimitiveItem p = new PrimitiveItem(dt instanceof DatabindableDatatype ? (DatabindableDatatype)dt : null, (Expression)exp);
        this.primitiveItems.put(exp, p);
        return p;
    }
}

