/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.annotator;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.msv.grammar.xmlschema.SimpleTypeExp;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.SuperClassItem;
import com.sun.tahiti.grammar.util.Multiplicity;
import com.sun.tahiti.grammar.util.MultiplicityCounter;
import com.sun.tahiti.reader.NameUtil;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

class FieldItemAnnotation {
    private static PrintStream debug = System.out;
    private final Map annotatedRefs = new HashMap();

    public static void annotate(AnnotatedGrammar g) {
        FieldItemAnnotation ann = new FieldItemAnnotation();
        ClassItem[] classes = g.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (debug != null) {
                debug.println(" adding field item for " + classes[i].getTypeName());
            }
            ClassItem classItem = classes[i];
            Expression expression = classes[i].exp;
            FieldItemAnnotation fieldItemAnnotation = ann;
            Objects.requireNonNull(fieldItemAnnotation);
            classItem.exp = expression.visit((ExpressionVisitorExpression)fieldItemAnnotation.new Annotator(g, classes[i]));
        }
    }

    private FieldItemAnnotation() {
    }

    private class Annotator
    extends ExpressionCloner {
        private final Stack names;
        private final AnnotatedGrammar grammar;
        private final ClassItem owner;

        private Annotator(AnnotatedGrammar g, ClassItem owner) {
            super(g.getPool());
            this.names = new Stack();
            this.owner = owner;
            this.grammar = g;
            this.names.push("content");
        }

        public Expression onRef(ReferenceExp exp) {
            Expression r = (Expression)FieldItemAnnotation.this.annotatedRefs.get(exp);
            if (r != null) {
                return r;
            }
            boolean pushed = false;
            if (exp.name != null && !(exp instanceof SimpleTypeExp)) {
                this.names.push(exp.name);
                pushed = true;
            }
            r = exp.exp.visit((ExpressionVisitorExpression)this);
            if (pushed) {
                FieldItemAnnotation.this.annotatedRefs.put(exp, r);
            }
            r.visit((ExpressionVisitorVoid)new ExpressionWalker(){

                public void onOther(OtherExp exp) {
                    if (exp instanceof FieldItem) {
                        return;
                    }
                    if (exp instanceof IgnoreItem) {
                        return;
                    }
                    if (exp instanceof JavaItem) {
                        System.err.println(exp);
                        throw new Error();
                    }
                }
            });
            if (pushed) {
                this.names.pop();
            }
            return r;
        }

        public Expression onOther(OtherExp exp) {
            if (exp instanceof PrimitiveItem || exp instanceof InterfaceItem || exp instanceof ClassItem) {
                return new FieldItem(this.decideName(exp.exp), (Expression)exp);
            }
            if (exp instanceof IgnoreItem || exp instanceof SuperClassItem || exp instanceof FieldItem) {
                return exp;
            }
            assert (!(exp instanceof JavaItem));
            return exp.exp.visit((ExpressionVisitorExpression)this);
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression body = this.visitXMLItemContent((NameClassAndExpression)exp);
            if (body == exp.exp) {
                return exp;
            }
            return this.pool.createAttribute(exp.nameClass, body, exp.getDefaultValue());
        }

        public Expression onElement(ElementExp exp) {
            Expression body = this.visitXMLItemContent((NameClassAndExpression)exp);
            if (body == exp.contentModel) {
                return exp;
            }
            return new ElementPattern(exp.getNameClass(), body);
        }

        private Expression visitXMLItemContent(NameClassAndExpression exp) {
            String name = null;
            NameClass nc = exp.getNameClass();
            if (nc instanceof SimpleNameClass) {
                name = ((SimpleNameClass)nc).localName;
            }
            if (exp == this.owner.exp) {
                name = null;
            }
            if (name != null) {
                this.names.push(name);
            }
            Expression body = exp.getContentModel().visit((ExpressionVisitorExpression)this);
            if (name != null) {
                this.names.pop();
            }
            return body;
        }

        public Expression onChoice(ChoiceExp exp) {
            int i;
            Expression[] b = exp.getChildren();
            boolean[] fieldlessBranch = new boolean[b.length];
            int numLiveBranch = 0;
            boolean bBranchWithField = false;
            final boolean[] bBranchWithPrimitive = new boolean[1];
            if (debug != null) {
                debug.println("Processing Choice: " + ExpressionPrinter.printContentModel((Expression)exp));
                debug.println("checking each branch");
            }
            for (i = 0; i < b.length; ++i) {
                final boolean[] hasChildFieldItem = new boolean[1];
                Multiplicity m = Multiplicity.calc(b[i], new MultiplicityCounter(){

                    @Override
                    protected Multiplicity isChild(Expression exp) {
                        if (exp instanceof FieldItem) {
                            hasChildFieldItem[0] = true;
                        }
                        if (exp instanceof PrimitiveItem) {
                            bBranchWithPrimitive[0] = true;
                        }
                        if (exp instanceof IgnoreItem) {
                            return Multiplicity.zero;
                        }
                        if (exp instanceof JavaItem) {
                            return Multiplicity.one;
                        }
                        return null;
                    }
                });
                if (debug != null) {
                    debug.println("  Branch: " + ExpressionPrinter.printContentModel((Expression)b[i]));
                    debug.println("    multiplicity:" + m + "  hasChildFieldItem:" + hasChildFieldItem[0]);
                }
                if (m.isZero()) continue;
                ++numLiveBranch;
                if (!hasChildFieldItem[0]) {
                    fieldlessBranch[i] = true;
                    continue;
                }
                bBranchWithField = true;
                b[i] = b[i].visit((ExpressionVisitorExpression)this);
            }
            if (numLiveBranch <= 1) {
                for (i = 0; i < b.length; ++i) {
                    if (!fieldlessBranch[i]) continue;
                    b[i] = b[i].visit((ExpressionVisitorExpression)this);
                }
                Expression r = Expression.nullSet;
                for (int i2 = 0; i2 < b.length; ++i2) {
                    r = this.pool.createChoice(r, b[i2]);
                }
                return r;
            }
            String fieldName = this.decideName((Expression)exp);
            Object r = Expression.nullSet;
            for (int i3 = 0; i3 < b.length; ++i3) {
                if (bBranchWithField && fieldlessBranch[i3]) {
                    b[i3] = new FieldItem(fieldName, b[i3]);
                }
                r = this.pool.createChoice(r, b[i3]);
            }
            if (!bBranchWithField) {
                r = new FieldItem(fieldName, (Expression)r);
            }
            return r;
        }

        private String decideName(Expression hint) {
            int idx;
            NameClass nc;
            String name = null;
            if (hint != null && hint instanceof NameClassAndExpression && (nc = ((NameClassAndExpression)hint).getNameClass()) instanceof SimpleNameClass) {
                return NameUtil.xmlNameToJavaName("field", ((SimpleNameClass)nc).localName);
            }
            if (name == null) {
                name = (String)this.names.pop();
            }
            for (idx = name.length() - 1; Character.isDigit(name.charAt(idx)) && idx >= 0; --idx) {
            }
            if (++idx == name.length()) {
                this.names.push(name + "1");
            } else {
                this.names.push(name.substring(0, idx) + (Integer.parseInt(name.substring(idx)) + 1));
            }
            return NameUtil.xmlNameToJavaName("field", name);
        }
    }
}

