/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader;

public class NameUtil {
    public static String toIdentifier(String name) {
        return NameUtil.xmlNameToJavaName("field", name);
    }

    public static String xmlNameToJavaName(String role, String xmlName) {
        if (role.equals("class")) {
            return NameUtil.convertToCamelNotation(xmlName, true);
        }
        if (role.equals("interface")) {
            return "I" + NameUtil.convertToCamelNotation(xmlName, true);
        }
        return NameUtil.convertToCamelNotation(xmlName, false);
    }

    private static String convertToCamelNotation(String name, boolean capitalizeFirstLetter) {
        StringBuffer r = new StringBuffer();
        boolean capitalize = capitalizeFirstLetter;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (NameUtil.isValidCharacterAsIdentifier(ch, r.length() == 0)) {
                if (capitalize) {
                    r.append(Character.toUpperCase(ch));
                } else {
                    r.append(ch);
                }
                capitalize = false;
                continue;
            }
            capitalize = true;
        }
        return r.toString();
    }

    private static boolean isValidCharacterAsIdentifier(char ch, boolean isFirstChar) {
        if ("$_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(ch) >= 0) {
            return true;
        }
        return !isFirstChar && "1234567890".indexOf(ch) >= 0;
    }

    public static String capitalizeFirst(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

