/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.sm;

import com.sun.msv.reader.GrammarReaderController;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.sm.MarshallerGenerator;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.util.xml.DocumentFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class MarshallerSerializer {
    public static void serialize(AnnotatedGrammar grammar, Symbolizer symbolizer, GrammarReaderController controller, DocumentHandler handler) throws SAXException, ParserConfigurationException, IOException {
        XMLWriter out = new XMLWriter(handler);
        try {
            out.handler.startDocument();
            out.start("unmarshaller");
            Parser parser = SAXParserFactory.newInstance().newSAXParser().getParser();
            ClassItem[] classes = grammar.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                out.start("class", new String[]{"name", classes[i].getTypeName()});
                byte[] marshaller = MarshallerGenerator.write(symbolizer, classes[i], controller);
                if (marshaller == null) {
                    out.element("unavailable");
                } else {
                    parser.setDocumentHandler(new DocumentFilter(out.handler){

                        @Override
                        public void startDocument() {
                        }

                        @Override
                        public void endDocument() {
                        }

                        @Override
                        public void processingInstruction(String target, String data) throws SAXException {
                            if (!target.equals("xml")) {
                                super.processingInstruction(target, data);
                            }
                        }
                    });
                    parser.parse(new InputSource(new ByteArrayInputStream(marshaller)));
                }
                out.end("class");
            }
            out.end("unmarshaller");
            out.handler.endDocument();
        }
        catch (XMLWriter.SAXWrapper w) {
            throw w.e;
        }
    }
}

