/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.sm;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.sm.FieldWalker;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.Type;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class MarshallerGenerator
implements ExpressionVisitorVoid {
    private final Symbolizer symbolizer;
    private final ClassItem owner;
    private final XMLWriter out;
    private final GrammarReaderController controller;
    private FieldItem currentField = null;
    static final String UNABLE_TO_PRODUCE_MARSHALLER_ONEORMORE = "MarshallerGenerator.OneOrMore";
    static final String UNABLE_TO_PRODUCE_MARSHALLER_UNDECIDABLE_CHOICE = "MarshallerGenerator.UndecidableChoice";
    static final String UNABLE_TO_PRODUCE_MARSHALLER_MULTIPLE_DEFAULTS = "MarshallerGenerator.MultipleDefaults";
    static final String UNABLE_TO_PRODUCE_MARSHALLER_IGNOREITEM = "Marshaller.IgnoreItem";

    public static void write(Symbolizer symbolizer, ClassItem cls, XMLWriter out, GrammarReaderController controller) {
        cls.exp.visit((ExpressionVisitorVoid)new MarshallerGenerator(symbolizer, cls, out, controller));
    }

    public static byte[] write(Symbolizer symbolizer, ClassItem cls, GrammarReaderController controller) throws SAXException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLWriter out = new XMLWriter((DocumentHandler)new XMLSerializer((OutputStream)baos, new OutputFormat("xml", null, true)));
            out.handler.startDocument();
            MarshallerGenerator.write(symbolizer, cls, out, controller);
            out.handler.endDocument();
            return baos.toByteArray();
        }
        catch (XMLWriter.SAXWrapper w) {
            throw w.e;
        }
        catch (Abort a) {
            return null;
        }
    }

    private MarshallerGenerator(Symbolizer symbolizer, ClassItem cls, XMLWriter out, GrammarReaderController controller) {
        this.symbolizer = symbolizer;
        this.owner = cls;
        this.out = out;
        this.controller = controller;
    }

    public void onOneOrMore(OneOrMoreExp exp) {
        Set uniqueFields = this.calcUniqueField(this.owner.exp, (Expression)exp);
        if (uniqueFields == null) {
            this.controller.warning(null, MarshallerGenerator.localize(UNABLE_TO_PRODUCE_MARSHALLER_ONEORMORE, this.owner.getTypeName()));
            throw new Abort();
        }
        if (uniqueFields.size() == 0) {
            exp.exp.visit((ExpressionVisitorVoid)this);
            return;
        }
        this.out.start("oneOrMore", new String[]{"while", this.setToString(uniqueFields)});
        exp.exp.visit((ExpressionVisitorVoid)this);
        this.out.end("oneOrMore");
    }

    public void onChoice(ChoiceExp exp) {
        Expression[] children = exp.getChildren();
        Expression otherwise = null;
        Expression undecidable = null;
        if (this.currentField != null) {
            boolean hasEpsilonEdge = false;
            boolean fail = false;
            boolean hasMarshallableItem = false;
            boolean hasPrimitiveItem = false;
            PrimitiveItem primitiveType = null;
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof InterfaceItem || children[i] instanceof ClassItem) {
                    hasMarshallableItem = true;
                    continue;
                }
                if (children[i] instanceof PrimitiveItem) {
                    hasPrimitiveItem = true;
                    PrimitiveItem thisType = (PrimitiveItem)children[i];
                    if (primitiveType == null) {
                        primitiveType = thisType;
                        continue;
                    }
                    if (primitiveType.dt == thisType.dt) continue;
                    fail = true;
                    continue;
                }
                if (children[i] instanceof IgnoreItem && children[i].isEpsilonReducible() || children[i] == Expression.epsilon) {
                    hasEpsilonEdge = true;
                    continue;
                }
                fail = true;
                break;
            }
            if (hasMarshallableItem && hasPrimitiveItem) {
                fail = true;
            }
            if (!fail && hasEpsilonEdge && !this.owner.getFieldUse((String)this.currentField.name).multiplicity.isAtMostOnce()) {
                fail = true;
            }
            if (!fail) {
                if (hasEpsilonEdge) {
                    this.out.start("choice");
                    this.out.start("option", new String[]{"if", this.currentField.name});
                }
                if (hasMarshallableItem) {
                    this.out.element("marshall", new String[]{"type", "object", "fieldName", this.currentField.name});
                } else {
                    this.out.element("marshall", new String[]{"type", "primitive", "fieldName", this.currentField.name, "dataSymbol", this.symbolizer.getId(primitiveType.exp)});
                }
                if (hasEpsilonEdge) {
                    this.out.end("option");
                    this.out.start("otherwise");
                    this.out.element("epsilon");
                    this.out.end("otherwise");
                    this.out.end("choice");
                }
                return;
            }
        }
        this.out.start("choice");
        for (int i = 0; i < children.length; ++i) {
            Set uniqueFields = this.calcUniqueField(this.owner.exp, children[i]);
            if (uniqueFields == null) {
                if (undecidable != null) {
                    this.controller.warning(null, MarshallerGenerator.localize(UNABLE_TO_PRODUCE_MARSHALLER_UNDECIDABLE_CHOICE, this.owner.getTypeName()));
                    throw new Abort();
                }
                undecidable = children[i];
                continue;
            }
            if (uniqueFields.size() == 0) {
                otherwise = children[i];
                continue;
            }
            this.out.start("option", new String[]{"if", this.setToString(uniqueFields)});
            children[i].visit((ExpressionVisitorVoid)this);
            this.out.end("option");
        }
        if (otherwise != null && undecidable != null) {
            this.controller.warning(null, MarshallerGenerator.localize(UNABLE_TO_PRODUCE_MARSHALLER_MULTIPLE_DEFAULTS, this.owner.getTypeName()));
            throw new Abort();
        }
        this.out.start("otherwise");
        if (otherwise != null) {
            otherwise.visit((ExpressionVisitorVoid)this);
        } else if (undecidable != null) {
            undecidable.visit((ExpressionVisitorVoid)this);
        } else {
            this.out.element("notPossible");
        }
        this.out.end("otherwise");
        this.out.end("choice");
    }

    private String setToString(Set s) {
        StringBuffer buffer = new StringBuffer();
        Iterator itr = s.iterator();
        while (itr.hasNext()) {
            buffer.append(' ');
            buffer.append(itr.next());
        }
        return buffer.toString();
    }

    public void onEpsilon() {
        this.out.element("epsilon");
    }

    public void onOther(OtherExp exp) {
        if (exp instanceof FieldItem) {
            assert (this.currentField == null);
            this.currentField = (FieldItem)exp;
            exp.exp.visit((ExpressionVisitorVoid)this);
            assert (this.currentField == exp);
            this.currentField = null;
            return;
        }
        if (exp instanceof ClassItem || exp instanceof InterfaceItem) {
            this.out.element("marshall", new String[]{"type", "object", "fieldName", this.currentField.name});
            return;
        }
        if (exp instanceof PrimitiveItem) {
            this.out.element("marshall", new String[]{"type", "primitive", "fieldName", this.currentField.name, "dataSymbol", this.symbolizer.getId(((PrimitiveItem)exp).exp)});
            return;
        }
        if (exp instanceof IgnoreItem) {
            if (!exp.exp.isEpsilonReducible()) {
                this.controller.warning(null, MarshallerGenerator.localize(UNABLE_TO_PRODUCE_MARSHALLER_IGNOREITEM, this.owner.getTypeName()));
                throw new Abort();
            }
            this.out.element("epsilon");
            return;
        }
        throw new Error(exp.toString());
    }

    public void onSequence(SequenceExp exp) {
        this.onGroup((BinaryExp)exp);
    }

    public void onInterleave(InterleaveExp exp) {
        this.onGroup((BinaryExp)exp);
    }

    public void onGroup(BinaryExp exp) {
        this.out.start("group");
        Expression[] children = exp.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].visit((ExpressionVisitorVoid)this);
        }
        this.out.end("group");
    }

    public void onAttribute(AttributeExp exp) {
        if (!(exp.nameClass instanceof SimpleNameClass)) {
            throw new Error();
        }
        this.onItem("attribute", (SimpleNameClass)exp.nameClass, exp.exp);
    }

    public void onElement(ElementExp exp) {
        if (!(exp.getNameClass() instanceof SimpleNameClass)) {
            throw new Error();
        }
        this.onItem("element", (SimpleNameClass)exp.getNameClass(), exp.contentModel);
    }

    public void onItem(String tag, SimpleNameClass nc, Expression body) {
        this.out.start(tag, new String[]{"uri", nc.namespaceURI, "name", nc.localName});
        body.visit((ExpressionVisitorVoid)this);
        this.out.end(tag);
    }

    public void onList(ListExp exp) {
        this.out.start("list");
        exp.exp.visit((ExpressionVisitorVoid)this);
        this.out.end("list");
    }

    public void onRef(ReferenceExp exp) {
        exp.exp.visit((ExpressionVisitorVoid)this);
    }

    public void onMixed(MixedExp exp) {
        throw new Error();
    }

    public void onConcur(ConcurExp exp) {
        throw new Error();
    }

    public void onAnyString() {
        throw new Error();
    }

    public void onNullSet() {
        throw new Error();
    }

    public void onData(DataExp exp) {
        throw new Error();
    }

    public void onValue(ValueExp exp) {
        throw new Error();
    }

    private Set calcUniqueField(Expression root, final Expression branch) {
        final HashSet branchFields = new HashSet();
        branch.visit((ExpressionVisitorVoid)new FieldWalker(this.currentField){

            @Override
            protected void findField(FieldItem field, Type child) {
                branchFields.add(field.name);
            }
        });
        root.visit(new ExpressionVisitorVoid(){
            private boolean visitBranch = false;
            private FieldItem currentField = null;

            public void onOther(OtherExp exp) {
                if (!this.test((Expression)exp)) {
                    return;
                }
                if (exp instanceof FieldItem) {
                    assert (this.currentField == null);
                    this.currentField = (FieldItem)exp;
                    exp.exp.visit((ExpressionVisitorVoid)this);
                    assert (this.currentField == exp);
                    this.currentField = null;
                    return;
                }
                if (exp instanceof ClassItem || exp instanceof InterfaceItem || exp instanceof PrimitiveItem) {
                    assert (this.currentField != null);
                    if (branchFields.remove(this.currentField.name)) {
                        // empty if block
                    }
                    return;
                }
                if (exp instanceof IgnoreItem) {
                    return;
                }
                assert (!(exp instanceof JavaItem));
                exp.exp.visit((ExpressionVisitorVoid)this);
            }

            public void onChoice(ChoiceExp exp) {
                this.onBinExp((BinaryExp)exp);
            }

            public void onSequence(SequenceExp exp) {
                this.onBinExp((BinaryExp)exp);
            }

            public void onInterleave(InterleaveExp exp) {
                this.onBinExp((BinaryExp)exp);
            }

            public void onBinExp(BinaryExp exp) {
                if (this.test((Expression)exp)) {
                    exp.exp1.visit((ExpressionVisitorVoid)this);
                    exp.exp2.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onElement(ElementExp exp) {
                if (this.test((Expression)exp)) {
                    exp.contentModel.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onAttribute(AttributeExp exp) {
                if (this.test((Expression)exp)) {
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onRef(ReferenceExp exp) {
                if (this.test((Expression)exp)) {
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onOneOrMore(OneOrMoreExp exp) {
                if (this.test((Expression)exp)) {
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onList(ListExp exp) {
                if (this.test((Expression)exp)) {
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onEpsilon() {
            }

            private boolean test(Expression exp) {
                if (exp != branch) {
                    return true;
                }
                if (this.visitBranch) {
                    branchFields.clear();
                } else {
                    this.visitBranch = true;
                }
                return false;
            }

            public void onMixed(MixedExp exp) {
                throw new Error();
            }

            public void onConcur(ConcurExp exp) {
                throw new Error();
            }

            public void onData(DataExp exp) {
                throw new Error();
            }

            public void onValue(ValueExp exp) {
                throw new Error();
            }

            public void onNullSet() {
                throw new Error();
            }

            public void onAnyString() {
                throw new Error();
            }
        });
        if (branchFields.size() == 0) {
            return null;
        }
        return branchFields;
    }

    private static String localize(String prop, Object arg) {
        return MarshallerGenerator.localize(prop, new Object[]{arg});
    }

    private static String localize(String prop, Object[] args) {
        String format = ResourceBundle.getBundle("com.sun.tahiti.compiler.sm.Messages").getString(prop);
        return MessageFormat.format(format, args);
    }

    public static class Abort
    extends RuntimeException {
    }
}

