/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.java;

import com.sun.tahiti.compiler.java.ClassSerializer;
import com.sun.tahiti.compiler.java.FieldSerializer;
import com.sun.tahiti.grammar.AccessModifier;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldUse;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.util.text.Formatter;
import java.io.PrintWriter;
import org.w3c.dom.Element;

class SetFieldSerializer
extends FieldSerializer {
    SetFieldSerializer(ClassSerializer parent, FieldUse fu) {
        super(parent, fu);
    }

    @Override
    void writeVariableDef(PrintWriter out, AccessModifier mod) {
        out.println("\t" + mod + " " + this.getTypeStr() + " " + this.fu.name + " = new " + this.getTypeStr() + "();");
    }

    @Override
    void writeGetterDef(PrintWriter out, AccessModifier mod) {
        out.println(Formatter.format("\t<%0> int get<%1>Size() {\n\t\treturn <%2>.size();\n\t}\n\t<%0> boolean contains<%1>( <%4> item ) {\n\t\treturn <%2>.contains(item);\n\t}\n\t<%0> java.util.Iterator iterate<%1>() {\n\t\treturn <%2>.iterator();\n\t}\n\t<%0> <%4>[] get<%1>s() {\n\t\treturn (<%4>[])<%2>.toArray(new <%4>[<%2>.size()]);\n\t}\n", new Object[]{mod, this.capitalizedFieldName, this.fu.name, this.getTypeStr(), this.parent.toPrintName(this.fu.type)}));
    }

    @Override
    void writeSetterDef(PrintWriter out, AccessModifier mod) {
        out.println(Formatter.format("\t<%0> void clear<%1>() {\n\t\t<%2>.clear();\n\t}\n\t<%0> boolean remove( <%4> item ) {\n\t\treturn <%2>.remove(item);\n\t}\n\t<%0> boolean add<%1>( <%4> item ) {\n\t\treturn <%2>.add(item);\n\t}\n", new Object[]{mod, this.capitalizedFieldName, this.fu.name, this.getTypeStr(), this.parent.toPrintName(this.fu.type)}));
    }

    @Override
    String getTypeStr() {
        return "java.util.Vector /* of " + this.parent.toPrintName(this.fu.type) + " */";
    }

    @Override
    String setField(String objName) {
        return SetFieldSerializer.format("this.{0}.add({1});", this.fu.name, objName);
    }

    @Override
    String marshallerInitializer() {
        return SetFieldSerializer.format("int idx_{0}=0; int len_{0}={0}.size();", this.fu.name);
    }

    @Override
    String hasMoreToken() {
        return SetFieldSerializer.format("idx_{0}!=len_{0}", this.fu.name);
    }

    @Override
    String marshall(Element e) {
        if (this.fu.type instanceof ClassItem || this.fu.type instanceof InterfaceItem) {
            return SetFieldSerializer.format("(({0}){1}.get(idx_{1}++)).marshall(out);", this.parent.toPrintName(this.fu.type), this.fu.name);
        }
        return SetFieldSerializer.format("out.data(({0}){1}.get(idx_{1}++), {2}.{3});", this.parent.toPrintName(this.fu.type), this.fu.name, this.parent.grammarShortClassName, e.getAttribute("dataSymbol"));
    }
}

