/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler;

import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.writer.ContentHandlerAdaptor;
import com.sun.tahiti.compiler.ControllerImpl;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.generator.ModelGenerator;
import com.sun.tahiti.compiler.ll.RuleGenerator;
import com.sun.tahiti.compiler.ll.RuleSerializer;
import com.sun.tahiti.compiler.ll.Rules;
import com.sun.tahiti.compiler.sm.MarshallerSerializer;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.TypeItem;
import com.sun.tahiti.reader.GrammarLoader;
import com.sun.tahiti.util.xml.XSLTUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class Driver {
    private static final OutputMethod java = new OutputMethod();
    private static final OutputMethod xml = new OutputMethod();

    private static void usage() {
        System.err.println("Usage: tahiti <options> <grammar file>\n[OUTPUT OPTIONS]\n  -out xml    compiler will produce xml files.\n  -out java   compiler will produce java source files.\n  -d <dir>    specify output directory.\n[GENERIC OPTIONS]\n  -package <package name>\n     place java files into the specified package.\n");
    }

    public static void main(String[] args) throws Exception {
        System.exit(Driver.run(args));
    }

    public static int run(String[] args) throws Exception {
        ControllerImpl controller;
        OutputMethod out = java;
        String grammarFileName = null;
        File outDir = new File(".");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-out")) {
                    if (args.length == ++i) {
                        Driver.usage();
                        return -1;
                    }
                    out = null;
                    if (args[i].equals("xml")) {
                        out = xml;
                    }
                    if (args[i].equals("java")) {
                        out = java;
                    }
                    if (out != null) continue;
                    Driver.usage();
                    return -1;
                }
                if (args[i].equals("-d")) {
                    if (args.length == ++i) {
                        Driver.usage();
                        return -1;
                    }
                    outDir = new File(args[i]);
                    continue;
                }
                System.out.println("unknown option:" + args[i]);
                Driver.usage();
                return -1;
            }
            if (grammarFileName != null) {
                System.err.println("more than one grammar specified");
                Driver.usage();
                return -1;
            }
            grammarFileName = args[i];
        }
        if (grammarFileName == null) {
            System.err.println("no grammar is specified");
            Driver.usage();
            return -1;
        }
        SAXParserFactoryImpl f = new SAXParserFactoryImpl();
        f.setNamespaceAware(true);
        System.err.println("parsing a schema...");
        DebugController grammarController = new DebugController(true, true);
        AnnotatedGrammar grammar = null;
        try {
            grammar = GrammarLoader.loadSchema(grammarFileName, (GrammarReaderController)grammarController, (SAXParserFactory)f);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            throw e;
        }
        if (grammar == null) {
            System.err.println("bailing out");
            return -1;
        }
        System.err.println("generating a grammar file...");
        XMLSerializer grammarReceiver = null;
        if (out == xml) {
            grammarReceiver = new XMLSerializer((OutputStream)new FileOutputStream(new File(outDir, "grammar.xml")), new OutputFormat("xml", null, true));
        } else {
            TransformerHandler xsltEngine = XSLTUtil.getTransformer(Driver.class.getResourceAsStream("grammar2java.xsl"));
            xsltEngine.setResult(new StreamResult(new FileOutputStream(Driver.getJavaFile(outDir, grammar.grammarName))));
            grammarReceiver = new ContentHandlerAdaptor((ContentHandler)xsltEngine);
        }
        Rules rules = RuleGenerator.create(grammar);
        Symbolizer symbolizer = RuleSerializer.serialize(grammar, rules, (DocumentHandler)grammarReceiver);
        if (out == xml) {
            System.err.println("generating marshallers...");
            XMLSerializer marshallerReceiver = null;
            marshallerReceiver = new XMLSerializer((OutputStream)new FileOutputStream(new File(outDir, "marshaller.xml")), new OutputFormat("xml", null, true));
            MarshallerSerializer.serialize(grammar, symbolizer, (GrammarReaderController)grammarController, (DocumentHandler)marshallerReceiver);
        }
        System.err.println("generating class definitions...");
        final File od = outDir;
        ModelGenerator generator = null;
        if (out == xml) {
            generator = ModelGenerator.xmlGenerator;
            controller = new ControllerImpl((GrammarReaderController)grammarController){

                @Override
                public OutputStream getOutput(TypeItem item) throws IOException {
                    return new FileOutputStream(new File(od, item.getTypeName() + ".xml"));
                }
            };
        } else {
            generator = ModelGenerator.javaGenerator;
            controller = new ControllerImpl((GrammarReaderController)grammarController){

                @Override
                public OutputStream getOutput(TypeItem item) throws IOException {
                    return new FileOutputStream(Driver.getJavaFile(od, item.getTypeName()));
                }
            };
        }
        generator.generate(grammar, symbolizer, controller);
        System.err.println("done.");
        return 0;
    }

    private static File getJavaFile(File parent, String javaPath) {
        File r = new File(parent, javaPath.replace('.', '/') + ".java");
        new File(r.getParent()).mkdirs();
        return r;
    }

    private static class OutputMethod {
        private OutputMethod() {
        }
    }
}

