/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.io.Files;
import java.io.File;
import net.java.ao.test.jdbc.H2;

public class H2File
extends H2 {
    private static final File TEMP_DIR = Files.createTempDir();
    private static final String DEFAULT_URL = H2File.makeDefaultUrl();

    private static String makeDefaultUrl() {
        StringBuilder url = new StringBuilder("jdbc:h2:file:");
        url.append(TEMP_DIR).append("/ao-test");
        if (H2File.h2VersionCompareTo(2, 1, 200) >= 0) {
            url.append(";MODE=LEGACY");
        }
        H2File.appendDriverSettings(url);
        return url.toString();
    }

    public H2File() {
        super(DEFAULT_URL);
    }

    public H2File(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUrl() {
        return DEFAULT_URL;
    }
}

