/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import org.apache.commons.lang3.ArrayUtils;

public abstract class H2
extends AbstractJdbcConfiguration {
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_SCHEMA = "PUBLIC";
    private static final Integer[] VERSION = H2.initH2Version();

    private static Integer[] initH2Version() {
        try {
            Class<?> H2Constants = Class.forName("org.h2.engine.Constants");
            return (Integer[])ArrayUtils.toArray((Object[])new Integer[]{(Integer)H2Constants.getDeclaredField("VERSION_MAJOR").get(null), (Integer)H2Constants.getDeclaredField("VERSION_MINOR").get(null), (Integer)H2Constants.getDeclaredField("BUILD_ID").get(null)});
        }
        catch (ClassNotFoundException e) {
            return (Integer[])ArrayUtils.toArray((Object[])new Integer[]{0, 0, 0});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static int h2VersionCompareTo(int major, int minor, int build) {
        Integer[] target = (Integer[])ArrayUtils.toArray((Object[])new Integer[]{major, minor, build});
        int result = 0;
        for (int i = 0; i < VERSION.length && (result = VERSION[i].compareTo(target[i])) == 0; ++i) {
        }
        return result;
    }

    protected static List<String> driverSettings() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (H2.h2VersionCompareTo(1, 4, 198) < 0) {
            parameters.add("MVCC=TRUE");
        }
        return parameters;
    }

    protected static void appendDriverSettings(StringBuilder url) {
        StringJoiner joiner = new StringJoiner(";", ";", "").setEmptyValue("");
        H2.driverSettings().forEach(joiner::add);
        url.append(joiner.toString());
    }

    public H2(String url) {
        this(url, "", "", DEFAULT_SCHEMA);
    }

    public H2(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUsername() {
        return "";
    }

    @Override
    protected String getDefaultPassword() {
        return "";
    }

    @Override
    protected String getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }
}

