/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing;

import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import net.jadler.KeyValues;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class StubResponse {
    public static final StubResponse EMPTY = StubResponse.builder().build();
    private final KeyValues headers;
    private final byte[] body;
    private final Charset encoding;
    private final int status;
    private final long delayValue;
    private final TimeUnit delayUnit;

    private StubResponse(int status, byte[] body, Charset encoding, KeyValues headers, long delayValue, TimeUnit delayUnit) {
        this.status = status;
        this.body = body;
        this.encoding = encoding;
        this.headers = headers;
        this.delayValue = delayValue;
        this.delayUnit = delayUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getBody() {
        return (byte[])this.body.clone();
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public KeyValues getHeaders() {
        return this.headers;
    }

    public long getDelay() {
        return this.delayUnit.toMillis(this.delayValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("status=").append(this.status).append(", body=");
        if (this.body.length > 0) {
            if (this.encoding != null) {
                sb.append(StringUtils.abbreviate((String)new String(this.body, this.encoding), (int)13));
                sb.append(", encoding=").append(this.encoding);
            } else {
                sb.append("<binary>");
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(", headers=(").append(this.headers.toString());
        sb.append("), delay=").append(this.delayValue).append(" ").append(this.delayUnit.toString().toLowerCase());
        return sb.toString();
    }

    public static class Builder {
        private int status = 200;
        private byte[] body = new byte[0];
        private Charset encoding = null;
        private KeyValues headers = new KeyValues();
        private long delayValue = 0L;
        private TimeUnit delayUnit = TimeUnit.MILLISECONDS;

        private Builder() {
        }

        public Builder status(int status) {
            Validate.isTrue((status >= 0 ? 1 : 0) != 0, (String)"status cannot be negative");
            this.status = status;
            return this;
        }

        public Builder body(byte[] body) {
            Validate.notNull((Object)body, (String)"body cannot be null, use an empty array instead");
            this.body = body;
            this.encoding = null;
            return this;
        }

        public Builder body(String body, Charset encoding) {
            Validate.notNull((Object)body, (String)"body cannot be null, use an empty string instead");
            Validate.notNull((Object)encoding, (String)"encoding cannot be null");
            this.body = body.getBytes(encoding);
            this.encoding = encoding;
            return this;
        }

        public Builder headers(KeyValues headers) {
            Validate.notNull((Object)headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder header(String name, String value) {
            Validate.notEmpty((String)name, (String)"name cannot be empty");
            Validate.notNull((Object)value, (String)"value cannot be null, use an empty string instead");
            this.headers = this.headers.add(name, value);
            return this;
        }

        public Builder delay(long delayValue, TimeUnit delayUnit) {
            Validate.isTrue((delayValue >= 0L ? 1 : 0) != 0, (String)"delayValue cannot be negative");
            Validate.notNull((Object)((Object)delayUnit), (String)"delayUnitCannot be null");
            this.delayValue = delayValue;
            this.delayUnit = delayUnit;
            return this;
        }

        public StubResponse build() {
            return new StubResponse(this.status, this.body, this.encoding, this.headers, this.delayValue, this.delayUnit);
        }
    }
}

