/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing;

import java.util.Iterator;
import java.util.List;
import net.jadler.Request;
import net.jadler.stubbing.Responder;
import net.jadler.stubbing.StubResponse;
import org.apache.commons.lang.Validate;

class StaticResponder
implements Responder {
    private final List<StubResponse> stubResponses;
    private int responsePointer = 0;

    StaticResponder(List<StubResponse> stubResponses) {
        Validate.notEmpty(stubResponses, (String)"stubResponses cannot be empty");
        this.stubResponses = stubResponses;
    }

    @Override
    public synchronized StubResponse nextResponse(Request request) {
        if (this.responsePointer < this.stubResponses.size() - 1) {
            return this.stubResponses.get(this.responsePointer++);
        }
        return this.stubResponses.get(this.responsePointer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<StubResponse> it = this.stubResponses.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\nfollowed by ");
        }
        return sb.toString();
    }
}

