/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jadler.KeyValues;
import net.jadler.stubbing.StubResponse;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

class MutableStubResponse {
    private final MultiMap headers = new MultiValueMap();
    private Charset encoding;
    private String stringBody;
    private byte[] rawBody;
    private int status;
    private long delay;

    MutableStubResponse() {
    }

    Charset getEncoding() {
        return this.encoding;
    }

    void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
    }

    String getStringBody() {
        return this.stringBody;
    }

    byte[] getRawBody() {
        return this.rawBody;
    }

    void setBody(String body) {
        this.stringBody = body;
        this.rawBody = null;
    }

    void setBody(byte[] body) {
        this.rawBody = body;
        this.stringBody = null;
    }

    MultiMap getHeaders() {
        return this.headers;
    }

    void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    void addHeaders(MultiMap headers) {
        this.headers.putAll((Map)headers);
    }

    void setHeaderCaseInsensitive(String name, String value) {
        MultiValueMap result = new MultiValueMap();
        for (Object o : this.headers.keySet()) {
            String key = (String)o;
            if (name.equalsIgnoreCase(key)) continue;
            for (String s : (Collection)this.headers.get(o)) {
                result.put(o, (Object)s);
            }
        }
        this.headers.clear();
        this.headers.putAll((Map)result);
        this.addHeader(name, value);
    }

    long getDelay() {
        return this.delay;
    }

    void setDelay(long delay) {
        this.delay = delay;
    }

    StubResponse toStubResponse() {
        StubResponse.Builder builder = StubResponse.builder().status(this.status).delay(this.delay, TimeUnit.MILLISECONDS).headers(this.createHeaders());
        if (this.stringBody != null) {
            if (this.encoding == null) {
                throw new IllegalStateException("The response body encoding has not been set yet, cannot generate a StubResponse instance.");
            }
            builder.body(this.stringBody, this.encoding);
        } else if (this.rawBody != null) {
            builder.body(this.rawBody);
        } else {
            throw new IllegalStateException("The response body has not been set yet, cannot generate a StubResponse instance.");
        }
        return builder.build();
    }

    private KeyValues createHeaders() {
        KeyValues res = new KeyValues();
        for (String key : this.headers.keySet()) {
            Iterator itValue = ((Collection)this.headers.get((Object)key)).iterator();
            while (itValue.hasNext()) {
                res = res.add(key, (String)itValue.next());
            }
        }
        return res;
    }
}

