/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.matchers;

import java.util.List;
import net.jadler.Request;
import net.jadler.matchers.RequestMatcher;
import org.apache.commons.lang.Validate;
import org.hamcrest.Matcher;

public class HeaderRequestMatcher
extends RequestMatcher<List<String>> {
    private final String headerName;
    private final String desc;

    protected HeaderRequestMatcher(Matcher<? super List<String>> pred, String headerName) {
        super(pred);
        Validate.notEmpty((String)headerName, (String)"headerName cannot be empty");
        this.headerName = headerName;
        this.desc = "header \"" + headerName + "\" is";
    }

    public static HeaderRequestMatcher requestHeader(String headerName, Matcher<? super List<String>> pred) {
        return new HeaderRequestMatcher(pred, headerName);
    }

    @Override
    protected List<String> retrieveValue(Request req) {
        return req.getHeaders().getValues(this.headerName);
    }

    @Override
    protected String provideDescription() {
        return this.desc;
    }
}

