/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.Validate;

public class KeyValues {
    public static final KeyValues EMPTY = new KeyValues();
    private final MultiMap values = new MultiValueMap();

    public KeyValues add(String key, String value) {
        Validate.notEmpty((String)key, (String)"key cannot be empty");
        Validate.notNull((Object)value, (String)"value cannot be null, use an empty string instead");
        KeyValues res = new KeyValues();
        res.values.putAll((Map)this.values);
        res.values.put((Object)key.toLowerCase(), (Object)value);
        return res;
    }

    public KeyValues addAll(KeyValues keyValues) {
        Validate.notNull((Object)keyValues, (String)"keyValues cannot be null");
        KeyValues res = new KeyValues();
        res.values.putAll((Map)this.values);
        res.values.putAll((Map)keyValues.values);
        return res;
    }

    public String getValue(String key) {
        Validate.notEmpty((String)key, (String)"key cannot be empty");
        List<String> allValues = this.getValues(key);
        return allValues != null ? allValues.get(0) : null;
    }

    public List<String> getValues(String key) {
        Validate.notEmpty((String)key, (String)"name cannot be empty");
        List result = (List)this.values.get((Object)key.toLowerCase());
        return result == null || result.isEmpty() ? null : new ArrayList(result);
    }

    public Set<String> getKeys() {
        HashSet<String> result = new HashSet<String>(this.values.keySet());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            Iterator it2 = ((Collection)e.getValue()).iterator();
            while (it2.hasNext()) {
                sb.append((String)e.getKey()).append(": ").append((String)it2.next());
                if (!it2.hasNext()) continue;
                sb.append(", ");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.values != null ? this.values.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValues other = (KeyValues)obj;
        return this.values == other.values || this.values != null && this.values.equals(other.values);
    }
}

