/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.nio.charset.Charset;
import net.jadler.JadlerConfiguration;
import net.jadler.JadlerMocker;
import net.jadler.exception.JadlerException;
import net.jadler.mocking.Verifying;
import net.jadler.stubbing.RequestStubbing;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.StubHttpServerManager;

public class Jadler {
    private static final ThreadLocal<JadlerMocker> jadlerMockerContainer = new InheritableThreadLocal<JadlerMocker>();
    private static final String JETTY_SERVER_CLASS = "net.jadler.stubbing.server.jetty.JettyStubHttpServer";

    private Jadler() {
    }

    public static OngoingConfiguration initJadler() {
        return Jadler.initInternal(new JadlerMocker(Jadler.getJettyServer()));
    }

    public static OngoingConfiguration initJadlerListeningOn(int port) {
        return Jadler.initInternal(new JadlerMocker(Jadler.getJettyServer(port)));
    }

    public static OngoingConfiguration initJadlerUsing(StubHttpServer server) {
        return Jadler.initInternal(new JadlerMocker(server));
    }

    public static void closeJadler() {
        StubHttpServerManager serverManager = jadlerMockerContainer.get();
        if (serverManager != null && serverManager.isStarted()) {
            serverManager.close();
        }
        jadlerMockerContainer.set(null);
    }

    public static void resetJadler() {
        JadlerMocker mocker = jadlerMockerContainer.get();
        if (mocker != null) {
            mocker.reset();
        }
    }

    public static int port() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().getStubHttpServerPort();
    }

    public static RequestStubbing onRequest() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().onRequest();
    }

    public static Verifying verifyThatRequest() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().verifyThatRequest();
    }

    private static void checkInitialized() {
        if (jadlerMockerContainer.get() == null) {
            throw new IllegalStateException("Jadler has not been initialized yet.");
        }
    }

    private static OngoingConfiguration initInternal(JadlerMocker jadlerMocker) {
        if (jadlerMockerContainer.get() != null) {
            throw new IllegalStateException("Jadler seems to have been initialized already.");
        }
        jadlerMockerContainer.set(jadlerMocker);
        jadlerMocker.start();
        return OngoingConfiguration.INSTANCE;
    }

    private static StubHttpServer getJettyServer() {
        Class<?> clazz = Jadler.getJettyStubHttpServerClass();
        try {
            return (StubHttpServer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JadlerException("Cannot instantiate default Jetty stub server", e);
        }
    }

    private static StubHttpServer getJettyServer(int port) {
        Class<?> clazz = Jadler.getJettyStubHttpServerClass();
        try {
            return (StubHttpServer)clazz.getConstructor(Integer.TYPE).newInstance(port);
        }
        catch (Exception e) {
            throw new JadlerException("Cannot instantiate default Jetty stub server with the given port", e);
        }
    }

    private static Class<?> getJettyStubHttpServerClass() {
        try {
            return Class.forName(JETTY_SERVER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new JadlerException("Class net.jadler.stubbing.server.jetty.JettyStubHttpServer cannot be found. Either add jadler-jetty to your classpath or use the initJadlerUsing method to specify the stub server explicitly.", e);
        }
    }

    public static class OngoingConfiguration
    implements JadlerConfiguration {
        private static final OngoingConfiguration INSTANCE = new OngoingConfiguration();

        private OngoingConfiguration() {
        }

        @Deprecated
        public OngoingConfiguration that() {
            return this;
        }

        @Deprecated
        public OngoingConfiguration respondsWithDefaultStatus(int defaultStatus) {
            return this.withDefaultResponseStatus(defaultStatus);
        }

        @Override
        public OngoingConfiguration withDefaultResponseStatus(int defaultStatus) {
            ((JadlerMocker)jadlerMockerContainer.get()).setDefaultStatus(defaultStatus);
            return this;
        }

        @Deprecated
        public OngoingConfiguration respondsWithDefaultHeader(String name, String value) {
            return this.withDefaultResponseHeader(name, value);
        }

        @Override
        public OngoingConfiguration withDefaultResponseHeader(String name, String value) {
            ((JadlerMocker)jadlerMockerContainer.get()).addDefaultHeader(name, value);
            return this;
        }

        @Deprecated
        public OngoingConfiguration respondsWithDefaultEncoding(Charset defaultEncoding) {
            return this.withDefaultResponseEncoding(defaultEncoding);
        }

        @Override
        public OngoingConfiguration withDefaultResponseEncoding(Charset defaultEncoding) {
            ((JadlerMocker)jadlerMockerContainer.get()).setDefaultEncoding(defaultEncoding);
            return this;
        }

        @Deprecated
        public OngoingConfiguration skipsRequestsRecording() {
            return this.withRequestsRecordingDisabled();
        }

        @Override
        public OngoingConfiguration withRequestsRecordingDisabled() {
            ((JadlerMocker)jadlerMockerContainer.get()).setRecordRequests(false);
            return this;
        }

        @Deprecated
        public OngoingConfiguration respondsWithDefaultContentType(String defaultContentType) {
            return this.withDefaultResponseContentType(defaultContentType);
        }

        @Override
        public OngoingConfiguration withDefaultResponseContentType(String defaultContentType) {
            return this.withDefaultResponseHeader("Content-Type", defaultContentType);
        }
    }
}

