/*
 * Copyright (c) 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: MXMLCompilerMojo.java 597 2008-01-14 22:46:31Z christianedwardgruber $
 */
package net.israfil.mojo.flex2;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;


/**
 * Compilation action for Flex2 actionscript 3 classes.
 * 
 * @author <a href="cgruber@israfil.net">Christian Edward Gruber</a>
 * @version $Id: MXMLCompilerMojo.java 597 2008-01-14 22:46:31Z christianedwardgruber $
 * 
 * @goal compile-swf
 * @requiresDependencyResolution
 * @phase compile
 * @requiresProject
 */
public class MXMLCompilerMojo extends AbstractFlexCompilerMojo {

    /**
     * 
     * 
     * @parameter expression="${flex.compiler.debug}" default="false"
     */
    protected boolean debug;	
	
    /**
	 * The main mxml file
	 * 
	 * @parameter alias="main" expression="${flex.application.name}" default="${project.artifactId}.mxml"
	 * @required
	 */
	protected String mainMxmlFile;

	public MXMLCompilerMojo() {
		super();
	}
	
	protected String getCompilerClass() { return "flex2.tools.Compiler"; }
	
	protected String getExecutableJar() { return "mxmlc.jar"; }

	protected  String getFileExtension() { return "swf"; }


    protected List prepareParameters() throws MojoFailureException, MojoExecutionException {
    	List parameters = super.prepareParameters();

		parameters.add("-compiler.debug=" + debug);    	
    	
    	return parameters;
    }
    
    protected void finalizeParameters(List parameters) throws MojoExecutionException, MojoFailureException {
    	super.finalizeParameters(parameters);
    	
    	// Conclude parameters.
    	parameters.add("--");
    	
    	// Add in main mxml file.
    	parameters.add(mainMxmlFile);

    }

}
