/*
 * Copyright (c) 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: CompCompilerMojo.java 573 2007-12-20 03:12:19Z christianedwardgruber $
 */
package net.israfil.mojo.flex2;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

import javax.swing.Renderer;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;


/**
 * API Document generator for Actionscript 3 code.
 * 
 * @author <a href="cgruber@israfil.net">Christian Edward Gruber</a>
 * @version $Id: CompCompilerMojo.java 573 2007-12-20 03:12:19Z christianedwardgruber $
 * 
 * @goal asdoc
 * @requiresDependencyResolution
 * @requiresProject
 */
public class ASDocMojo extends AbstractFlexMojo implements MavenReport {

    /**
     * Generates the site report
     *
     * @component
     */
    private Renderer siteRenderer;

    /**
     * Specifies the destination directory where javadoc saves the generated HTML files.
     *
     * @parameter expression="${project.reporting.outputDirectory}/apidocs"
     * @required
     */
    private File reportOutputDirectory;

    /**
     * The name of the destination directory.
     *
     * @parameter expression="${destDir}" default-value="apidocs"
     */
    private String destDir;

    /**
	 * The location of the asdoc templates to be used in generating documentation
	 * 
	 * @parameter expression="${asdoc.templates}" default-value="${flex.home}/asdoc/templates"
	 * @required 
	 */
	protected File asdocTemplates;
		
    /**
     * Report name
     *
     * @parameter default-value="ASDocs"
     * @required
     */
    private String name;
    
    /**
     * Report description
     *
     * @parameter default-value="ASDoc Actionscript API Documentation"
     * @required
     */
    private String description;

	public boolean canGenerateReport() {
        // TODO: Make this do aggregate reports of all sub-projects.
        // See: JavadocReport
        return true;
	}

	public String getCategoryName() {
		return CATEGORY_PROJECT_REPORTS;
	}

    public String getDescription( Locale locale ) {
        return description;
    }

	public String getName(Locale locale) {
        return name;
	}

	public String getOutputName() {
		return destDir + "/index";
	}

	public File getReportOutputDirectory() {
		return reportOutputDirectory;
	}

	public boolean isExternalReport() {
		return true;
	}

    /**
     * Method to set the directory where the generated reports will be put.  As
     * with Javadoc, make sure that the resulting path ends with ${destdir}
     *
     * @param reportOutputDirectory the directory file to be set
     */
    public void setReportOutputDirectory( File reportOutputDirectory ) {
        if ( ( reportOutputDirectory != null ) && ( !reportOutputDirectory.getAbsolutePath().endsWith( destDir ) ) ){
            this.reportOutputDirectory = new File( reportOutputDirectory, destDir );
        } else {
            this.reportOutputDirectory = reportOutputDirectory;
        }
    }

	public void generate(Sink sink, Locale locale) throws MavenReportException {
		// TODO Auto-generated method stub
		
	}


	protected String getCompilerClass() { return "flex2.tools.ASDoc"; }
	
	protected String getExecutableJar() { return "asdoc.jar"; }

	protected File getOutputFile() {
		return getFile(outputDirectory, finalName, "asdoc");

	}

	protected String getFileExtension() {
		// TODO Auto-generated method stub
		return null;
	}

	
    protected List prepareParameters() throws MojoFailureException, MojoExecutionException {
    	List parameters = super.prepareParameters();

		parameters.add( "-doc-sources" );
		
		try {
			parameters.add( source.getCanonicalPath());
		} catch (IOException e) {
			throw new MojoExecutionException("Source path doesn't exist.", e);
		}
		
		parameters.add( "-templates-path" );
		
		try {
			parameters.add( asdocTemplates.getCanonicalPath());
		} catch (IOException e) {
			throw new MojoExecutionException("Templates path doesn't exist.", e);
		}
		
		// define output folder.
		parameters.add("-output");
		File asdocOutput = reportOutputDirectory;
		try {
			parameters.add(asdocOutput.getCanonicalPath());
		} catch (IOException e) {
			throw new MojoExecutionException("Exception attempting to set output file: " + asdocOutput.getPath(), e);
		}		
     	
    	return parameters;
    }
    
    protected void postProcess() {
    	
    	
    	
    }
    


/*
asdoc -source-path C:\flex\frameworks\source 
    -doc-classes mx.controls.Button 
    -main-title "Flex API Documentation" 
    -window-title "Flex API Documentation" 
    -output flex-framework-asdoc
    
asdoc -source-path . -doc-classes comps.GraphingWidget comps.GraphingWidgetTwo

asdoc -source-path C:\flex\class_dir -doc-classes comps.GraphingWidget comps.GraphingWidgetTwo

asdoc -source-path . -doc-sources .

asdoc -source-path frameworks 
    -namespace http://framework frameworks/core-framework-manifest.xml 
    -doc-namespaces http://framework

asdoc -source-path . -doc-sources . -exclude-classes comps.PageWidget comps.ScreenWidget 

Option
Description
-doc-classes path-element [...]	
A list of classes to document. These classes must be in the source path. This is the default option.
This option works the same way as does the -include-classes option for the compc component compiler. For more information, see Using the component compiler.
-doc-namespaces uri manifest	
A list of URIs whose classes should be documented. The classes must be in the source path.
You must include a URI and the location of the manifest file that defines the contents of this namespace.
This option works the same way as does the -include-namespaces option for the compc component compiler. For more information, see Using the component compiler.
-doc-sources path-element [...]	
A list of files that should be documented. If a directory name is in the list, it is recursively searched.
This option works the same way as does the -include-sources option for the compc component compiler. For more information, see Using the component compiler.
-exclude-classes string	
A list of classes that should not be documented. You must specify individual class names. Alternatively, if the ASDoc comment for the class contains the @private tag, is not documented.
-exclude-dependencies true|false	
Whether all dependencies found by the compiler are documented. If true, the dependencies of the input classes are not documented.
The default value is false.
-footer string	
The text that appears at the bottom of the HTML pages in the output documentation.
-left-frameset-width int	
An integer that changes the width of the left frameset of the documentation. You can change this size to accommodate the length of your package names.
The default value is 210 pixels.
-main-title "string"	
The text that appears at the top of the HTML pages in the output documentation.
The default value is "API Documentation".
-output string	
The output directory for the generated documentation. The default value is "asdoc-output".
-package name "description"	
The descriptions to use when describing a package in the documentation. You can specify more than one package option.
The following example adds two package descriptions to the output:
asdoc -doc-sources my_dir -output myDoc -package com.my.business "Contains business classes and interfaces" -package com.my.commands "Contains command base classes and interfaces"
-templates-path string	
The path to the ASDoc template directory. The default is the asdoc/templates directory in the ASDoc installation directory. This directory contains all the HTML, CSS, XSL, and image files used for generating the output.
-window-title "string"	
The text that appears in the browser window in the output documentation.
The default value is "API Documentation".
The asdoc command also recognizes the following options from the compc component compiler:

-source-path
-library-path
-namespace
-load-config
-actionscript-file-encoding
-help
-advanced
-benchmark
-strict
-warnings


-benchmark
-compiler.accessible
-compiler.actionscript-file-encoding <string>
-compiler.context-root <context-path>
-compiler.debug
-compiler.external-library-path [path-element] [...]
-compiler.fonts.flash-type
-compiler.fonts.max-glyphs-per-face <string>
-compiler.include-libraries [library] [...]
-compiler.incremental
-compiler.library-path [path-element] [...]
-compiler.locale <string>
-compiler.namespaces.namespace <uri> <manifest>
-compiler.optimize
-compiler.services <filename>
-compiler.show-actionscript-warnings
-compiler.show-binding-warnings
-compiler.show-deprecation-warnings
-compiler.show-unused-type-selector-warnings
-compiler.source-path [path-element] [...]
-compiler.strict
-compiler.theme [filename] [...]
-compiler.use-resource-bundle-metadata
-doc-classes [class] [...]
-doc-namespaces [uri] [...]
-doc-sources [path-element] [...]
-exclude-classes [class] [...]
-exclude-dependencies
-footer <string>
-help [keyword] [...]
-left-frameset-width <int>
-licenses.license <product> <serial-number>
-load-config <filename>
-main-title <string>
-metadata.contributor <name>
-metadata.creator <name>
-metadata.date <text>
-metadata.description <text>
-metadata.language <code>
-metadata.localized-description <text> <lang>
-metadata.localized-title <title> <lang>
-metadata.publisher <name>
-metadata.title <text>
-output <filename>
-packages.package <string> <string>
-runtime-shared-libraries [url] [...]
-templates-path <string>
-use-network
-version
-window-title <string>

*/


}
