/*
 * Copyright (c) 2006, 2007 Israfil Consulting Services Corporation
 * Copyright (c) 2006, 2007 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: AbstractFlexMojo.java 526 2007-09-05 16:38:27Z christianedwardgruber $
 */
package net.israfil.mojo.flex2;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

/**
 * Utility class to support the wrapping of main() execution.  This allows a long 
 * command-line to be invoked in a short space, with all parameters being passed in
 * on standard-in.  This, of course, is not helpful for those
 * programs that need actual use of System.in.
 *
 * @author <a href="cgruber@israfil.net">Christian Edward Gruber</a>
 * @version $Id: AbstractFlexMojo.java 526 2007-09-05 16:38:27Z christianedwardgruber $
 */
public abstract class StringStreamUtil  {
	
	public static String SPLIT_SEPARATOR = "\u0000";
	public static String END_OF_PARAMETERS = "\u0000\u0000\u0000";
    

	public static InputStream prepareInputStreamFromStrings(List strings) {	
		try {
			StringBuffer sb = new StringBuffer();
			boolean first = true;
			for (Iterator iterator = strings.iterator(); iterator.hasNext() ;) {
				if (first) { 
					first = false;
				} else {
					sb.append(SPLIT_SEPARATOR);
				}				
				sb.append((String)iterator.next());
			}
			sb.append(END_OF_PARAMETERS);
			sb.append("\n");
			byte[] byteArray = sb.toString().getBytes("UTF-8"); // choose a charset
			return new ByteArrayInputStream(byteArray);
		} catch (Throwable t) {
			throw new RuntimeException(t); // fail big.
		}
	}

	public static String[] extractParametersFromStream(InputStream in) {
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(in,"UTF-8"));
			StringBuffer sb = new StringBuffer();
			String line = null;
			while ((line = reader.readLine()) != null) {
				if (line.contains(END_OF_PARAMETERS)) {
					sb.append(line.split(END_OF_PARAMETERS)[0]);
					break;
				} else sb.append(line);
			}
			return sb.toString().split(SPLIT_SEPARATOR);
		} catch (Throwable t) {
			throw new RuntimeException(t); // fail big.
		}
	}

}
