/*
 * Copyright (c) 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: AbstractFlexMojo.java 526 2007-09-05 16:38:27Z christianedwardgruber $
 */
package net.israfil.mojo.flex2;

import java.lang.reflect.Method;
import java.util.Arrays;

/** 
 * A small class that has a static main(String[]), and takes another class
 * which contains a static main(String[]) method.  It then wraps that class'
 * main() invocation, pulling all parameter data from standard in, with each
 * parameter separated by \u0000.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian E Gruber</a>
 * @version $Id: AbstractFlexMojo.java 526 2007-09-05 16:38:27Z christianedwardgruber $
 */
public class StreamedParameterExecutableWrapper {

	public static void main(String[] args) {
		if (args.length < 1) 
			throw new IllegalArgumentException("Must declare the wrapped class.");
		String startupClassName = args[0];
		String[] newArgs = null;
		Method m = null;
		try {
			newArgs = StringStreamUtil.extractParametersFromStream(System.in);
			Class startupClass = Thread.currentThread().getContextClassLoader().loadClass(startupClassName);
			m = startupClass.getMethod("main", new Class[]{ String[].class });
			//m = DynamicUtil.getMethodForSelector(startupClass, "main:String[]");
			System.err.println("Executing main with args " + Arrays.asList(newArgs));
			m.invoke(null, new Object[]{newArgs}); // static main.
		} catch (Throwable t) {
			System.out.println("Failed to invoke " + m + " with parameters: " + Arrays.asList(newArgs));
			t.printStackTrace();
			throw new RuntimeException(t);
		}
	}



}
